/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.isolationsegments;

import org.cloudfoundry.client.v3.isolationsegments.AddIsolationSegmentOrganizationEntitlementRequest;
import org.cloudfoundry.client.v3.isolationsegments.AddIsolationSegmentOrganizationEntitlementResponse;
import org.cloudfoundry.client.v3.isolationsegments.CreateIsolationSegmentRequest;
import org.cloudfoundry.client.v3.isolationsegments.CreateIsolationSegmentResponse;
import org.cloudfoundry.client.v3.isolationsegments.DeleteIsolationSegmentRequest;
import org.cloudfoundry.client.v3.isolationsegments.GetIsolationSegmentRequest;
import org.cloudfoundry.client.v3.isolationsegments.GetIsolationSegmentResponse;
import org.cloudfoundry.client.v3.isolationsegments.IsolationSegments;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentEntitledOrganizationsRequest;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentEntitledOrganizationsResponse;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentOrganizationsRelationshipRequest;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentOrganizationsRelationshipResponse;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentSpacesRelationshipRequest;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentSpacesRelationshipResponse;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentsRequest;
import org.cloudfoundry.client.v3.isolationsegments.ListIsolationSegmentsResponse;
import org.cloudfoundry.client.v3.isolationsegments.RemoveIsolationSegmentOrganizationEntitlementRequest;
import org.cloudfoundry.client.v3.isolationsegments.UpdateIsolationSegmentRequest;
import org.cloudfoundry.client.v3.isolationsegments.UpdateIsolationSegmentResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorIsolationSegments
extends AbstractClientV3Operations
implements IsolationSegments {
    public ReactorIsolationSegments(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<AddIsolationSegmentOrganizationEntitlementResponse> addOrganizationEntitlement(AddIsolationSegmentOrganizationEntitlementRequest request) {
        return this.post(request, AddIsolationSegmentOrganizationEntitlementResponse.class, builder -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId(), "relationships", "organizations"})).checkpoint();
    }

    public Mono<CreateIsolationSegmentResponse> create(CreateIsolationSegmentRequest request) {
        return this.post(request, CreateIsolationSegmentResponse.class, builder -> builder.pathSegment(new String[]{"isolation_segments"})).checkpoint();
    }

    public Mono<Void> delete(DeleteIsolationSegmentRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId()})).checkpoint();
    }

    public Mono<GetIsolationSegmentResponse> get(GetIsolationSegmentRequest request) {
        return this.get((Object)request, GetIsolationSegmentResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId()})).checkpoint();
    }

    public Mono<ListIsolationSegmentsResponse> list(ListIsolationSegmentsRequest request) {
        return this.get((Object)request, ListIsolationSegmentsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"isolation_segments"})).checkpoint();
    }

    public Mono<ListIsolationSegmentEntitledOrganizationsResponse> listEntitledOrganizations(ListIsolationSegmentEntitledOrganizationsRequest request) {
        return this.get((Object)request, ListIsolationSegmentEntitledOrganizationsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId(), "organizations"})).checkpoint();
    }

    public Mono<ListIsolationSegmentOrganizationsRelationshipResponse> listOrganizationsRelationship(ListIsolationSegmentOrganizationsRelationshipRequest request) {
        return this.get((Object)request, ListIsolationSegmentOrganizationsRelationshipResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId(), "relationships", "organizations"})).checkpoint();
    }

    public Mono<ListIsolationSegmentSpacesRelationshipResponse> listSpacesRelationship(ListIsolationSegmentSpacesRelationshipRequest request) {
        return this.get((Object)request, ListIsolationSegmentSpacesRelationshipResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId(), "relationships", "spaces"})).checkpoint();
    }

    public Mono<Void> removeOrganizationEntitlement(RemoveIsolationSegmentOrganizationEntitlementRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId(), "relationships", "organizations", request.getOrganizationId()})).checkpoint();
    }

    public Mono<UpdateIsolationSegmentResponse> update(UpdateIsolationSegmentRequest request) {
        return this.patch(request, UpdateIsolationSegmentResponse.class, builder -> builder.pathSegment(new String[]{"isolation_segments", request.getIsolationSegmentId()})).checkpoint();
    }
}

