/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientResponse;

final class MultipartCodec {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipartCodec.class);
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("multipart/.+; boundary=(.*)");
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private MultipartCodec() {
    }

    static DelimiterBasedFrameDecoder createDecoder(HttpClientResponse response) {
        String boundary = MultipartCodec.extractMultipartBoundary(response);
        return new DelimiterBasedFrameDecoder(0x100000, new ByteBuf[]{Unpooled.copiedBuffer((CharSequence)String.format("--%s\r\n\r\n", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s\r\n\r\n", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s--", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s--\r\n", boundary), (Charset)Charset.defaultCharset())});
    }

    static Flux<InputStream> decode(ByteBufFlux body) {
        return body.asInputStream().skip(1L).doOnDiscard(InputStream.class, MultipartCodec::close);
    }

    private static String extractMultipartBoundary(HttpClientResponse response) {
        String contentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Matcher matcher = BOUNDARY_PATTERN.matcher(contentType);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException(String.format("Content-Type %s does not contain a valid multipart boundary", contentType));
    }

    private static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not close input stream. This will cause a direct memory leak.", (Throwable)e);
        }
    }
}

