/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.routing.v1;

import io.netty.channel.ChannelHandler;
import java.util.function.Function;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClientResponse;

public abstract class AbstractRoutingV1Operations
extends AbstractReactorOperations {
    protected AbstractRoutingV1Operations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    protected final <T> Mono<T> get(Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.get().uri(uriTransformer).response().parseBody(responseType));
    }

    protected final <T> Flux<T> get(Function<HttpClientResponse, ChannelHandler> handlerBuilder, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<ByteBufFlux, Flux<T>> bodyTransformer) {
        return this.createOperator().flatMapMany(operator -> operator.get().uri(uriTransformer).response().addChannelHandler(handlerBuilder).parseBodyToFlux(responseWithBody -> (Flux)bodyTransformer.apply(responseWithBody.getBody())));
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.post().uri(uriTransformer).send(request).response().parseBody(responseType));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.createOperator().flatMap(operator -> operator.put().uri(uriTransformer).send(requestPayload).response().parseBody(responseType));
    }
}

