/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.util.List;
import org.cloudfoundry.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;

public class RequestLogger {
    static final Logger REQUEST_LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.request");
    static final Logger RESPONSE_LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.response");
    private static final String CF_WARNINGS = "X-Cf-Warnings";
    private long requestSentTime;

    public void request(HttpClientRequest request) {
        this.request(String.format("%-5s {}", request.method()), request.uri());
    }

    public void response(HttpClientResponse response) {
        if (!RESPONSE_LOGGER.isDebugEnabled()) {
            return;
        }
        String elapsed = TimeUtils.asTime((long)(System.currentTimeMillis() - this.requestSentTime));
        List warnings = response.responseHeaders().getAll(CF_WARNINGS);
        if (warnings.isEmpty()) {
            RESPONSE_LOGGER.debug("{}    {} ({})", new Object[]{response.status().code(), response.uri(), elapsed});
        } else {
            RESPONSE_LOGGER.warn("{}    {} ({}) [{}]", new Object[]{response.status().code(), response.uri(), elapsed, String.join((CharSequence)", ", warnings)});
        }
    }

    public void websocketRequest(String uri) {
        this.request("WS     {}", uri);
    }

    private void request(String message, String uri) {
        REQUEST_LOGGER.debug(message, (Object)uri);
        this.requestSentTime = System.currentTimeMillis();
    }
}

