package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;

/**
 * A {@link RootProvider} that returns endpoints extracted from the `/` API for the configured endpoint.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RootPayloadRootProvider"})
public final class RootPayloadRootProvider extends org.cloudfoundry.reactor._RootPayloadRootProvider {
  private final ObjectMapper objectMapper;
  private final String apiHost;
  private final Integer port;
  private final Boolean secure;

  private RootPayloadRootProvider(RootPayloadRootProvider.Builder builder) {
    this.objectMapper = builder.objectMapper;
    this.apiHost = builder.apiHost;
    this.port = builder.port;
    this.secure = builder.secure;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    return objectMapper;
  }

  /**
   * The hostname of the API root.  Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * The port for the Cloud Foundry instance. Defaults to {@code 443}.
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * Whether the connection to the root API should be secure (i.e. using HTTPS).  Defaults to {@code true}.
   */
  @Override
  public Optional<Boolean> getSecure() {
    return Optional.ofNullable(secure);
  }

  /**
   * This instance is equal to all instances of {@code RootPayloadRootProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RootPayloadRootProvider
        && equalTo((RootPayloadRootProvider) another);
  }

  private boolean equalTo(RootPayloadRootProvider another) {
    return objectMapper.equals(another.objectMapper)
        && apiHost.equals(another.apiHost)
        && Objects.equals(port, another.port)
        && Objects.equals(secure, another.secure);
  }

  /**
   * Computes a hash code from attributes: {@code objectMapper}, {@code apiHost}, {@code port}, {@code secure}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + objectMapper.hashCode();
    h += (h << 5) + apiHost.hashCode();
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(secure);
    return h;
  }

  /**
   * Prints the immutable value {@code RootPayloadRootProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RootPayloadRootProvider{");
    builder.append("objectMapper=").append(objectMapper);
    builder.append(", ");
    builder.append("apiHost=").append(apiHost);
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    if (secure != null) {
      builder.append(", ");
      builder.append("secure=").append(secure);
    }
    return builder.append("}").toString();
  }


  private static RootPayloadRootProvider validate(RootPayloadRootProvider instance) {
    instance.checkForValidApiHost();
    return instance;
  }

  /**
   * Creates a builder for {@link RootPayloadRootProvider RootPayloadRootProvider}.
   * @return A new RootPayloadRootProvider builder
   */
  public static RootPayloadRootProvider.Builder builder() {
    return new RootPayloadRootProvider.Builder();
  }

  /**
   * Builds instances of type {@link RootPayloadRootProvider RootPayloadRootProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_OBJECT_MAPPER = 0x1L;
    private static final long INIT_BIT_API_HOST = 0x2L;
    private long initBits = 0x3L;

    private ObjectMapper objectMapper;
    private String apiHost;
    private Integer port;
    private Boolean secure;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.AbstractRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code RootPayloadRootProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RootPayloadRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _RootPayloadRootProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RootPayloadRootProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractRootProvider) {
        AbstractRootProvider instance = (AbstractRootProvider) object;
        Optional<Boolean> secureOptional = instance.getSecure();
        if (secureOptional.isPresent()) {
          secure(secureOptional);
        }
        Optional<Integer> portOptional = instance.getPort();
        if (portOptional.isPresent()) {
          port(portOptional);
        }
        apiHost(instance.getApiHost());
      }
      if (object instanceof org.cloudfoundry.reactor._RootPayloadRootProvider) {
        org.cloudfoundry.reactor._RootPayloadRootProvider instance = (org.cloudfoundry.reactor._RootPayloadRootProvider) object;
        objectMapper(instance.getObjectMapper());
      }
    }

    /**
     * Initializes the value for the {@link _RootPayloadRootProvider#getObjectMapper() objectMapper} attribute.
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      initBits &= ~INIT_BIT_OBJECT_MAPPER;
      return this;
    }

    /**
     * Initializes the value for the {@link _RootPayloadRootProvider#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link _RootPayloadRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link _RootPayloadRootProvider#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link _RootPayloadRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for chained invocation
     */
    public final Builder secure(boolean secure) {
      this.secure = secure;
      return this;
    }

    /**
     * Initializes the optional value {@link _RootPayloadRootProvider#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secure(Optional<Boolean> secure) {
      this.secure = secure.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link RootPayloadRootProvider RootPayloadRootProvider}.
     * @return An immutable instance of RootPayloadRootProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RootPayloadRootProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return RootPayloadRootProvider.validate(new RootPayloadRootProvider(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_OBJECT_MAPPER) != 0) attributes.add("objectMapper");
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      return "Cannot build RootPayloadRootProvider, some of required attributes are not set " + attributes;
    }
  }
}
