/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.routing.v1.tcproutes;

import java.io.IOException;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.routing.v1.AbstractRoutingV1Operations;
import org.cloudfoundry.reactor.routing.v1.tcproutes.EventStreamCodec;
import org.cloudfoundry.routing.v1.tcproutes.CreateTcpRoutesRequest;
import org.cloudfoundry.routing.v1.tcproutes.CreateTcpRoutesResponse;
import org.cloudfoundry.routing.v1.tcproutes.DeleteTcpRoutesRequest;
import org.cloudfoundry.routing.v1.tcproutes.EventType;
import org.cloudfoundry.routing.v1.tcproutes.EventsRequest;
import org.cloudfoundry.routing.v1.tcproutes.ListTcpRoutesRequest;
import org.cloudfoundry.routing.v1.tcproutes.ListTcpRoutesResponse;
import org.cloudfoundry.routing.v1.tcproutes.TcpRouteEvent;
import org.cloudfoundry.routing.v1.tcproutes.TcpRoutes;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorTcpRoutes
extends AbstractRoutingV1Operations
implements TcpRoutes {
    private final ConnectionContext connectionContext;

    public ReactorTcpRoutes(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
        this.connectionContext = connectionContext;
    }

    public Mono<CreateTcpRoutesResponse> create(CreateTcpRoutesRequest request) {
        return this.post(request, CreateTcpRoutesResponse.class, builder -> builder.pathSegment(new String[]{"v1", "tcp_routes", "create"})).checkpoint();
    }

    public Mono<Void> delete(DeleteTcpRoutesRequest request) {
        return this.post(request, Void.class, builder -> builder.pathSegment(new String[]{"v1", "tcp_routes", "delete"})).checkpoint();
    }

    public Flux<TcpRouteEvent> events(EventsRequest request) {
        return this.get(builder -> builder.pathSegment(new String[]{"v1", "tcp_routes", "events"})).flatMapMany(EventStreamCodec::decode).map(event -> {
            try {
                return ((TcpRouteEvent.Builder)this.connectionContext.getObjectMapper().readValue(event.getData(), TcpRouteEvent.Builder.class)).eventType(EventType.from((String)event.getEventType())).build();
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).checkpoint();
    }

    public Mono<ListTcpRoutesResponse> list(ListTcpRoutesRequest request) {
        return this.get(ListTcpRoutesResponse.class, builder -> builder.pathSegment(new String[]{"v1", "tcp_routes"})).checkpoint();
    }
}

