/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.tokenprovider;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AsciiString;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.NetworkLogging;
import org.cloudfoundry.reactor.util.UserAgent;
import org.cloudfoundry.uaa.UaaException;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public abstract class AbstractUaaTokenProvider
implements TokenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cloudfoundry-client.token");
    private static final String ACCESS_TOKEN = "access_token";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String TOKEN_TYPE = "token_type";
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final ConcurrentMap<ConnectionContext, Mono<String>> accessTokens = new ConcurrentHashMap<ConnectionContext, Mono<String>>(1);
    private final ConcurrentMap<ConnectionContext, ReplayProcessor<String>> refreshTokenStreams = new ConcurrentHashMap<ConnectionContext, ReplayProcessor<String>>(1);
    private final ConcurrentMap<ConnectionContext, Mono<String>> refreshTokens = new ConcurrentHashMap<ConnectionContext, Mono<String>>(1);

    @Value.Default
    public String getClientId() {
        return "cf";
    }

    @Value.Default
    public String getClientSecret() {
        return "";
    }

    public Flux<String> getRefreshTokens(ConnectionContext connectionContext) {
        return this.getRefreshTokenStream(connectionContext);
    }

    @Override
    public final Mono<String> getToken(ConnectionContext connectionContext) {
        return this.accessTokens.computeIfAbsent(connectionContext, this::token);
    }

    @Override
    public void invalidate(ConnectionContext connectionContext) {
        this.accessTokens.put(connectionContext, this.token(connectionContext));
    }

    @Nullable
    abstract String getIdentityZoneSubdomain();

    abstract Mono<Void> tokenRequestTransformer(Mono<HttpClientRequest> var1);

    private static HttpClientRequest addContentType(HttpClientRequest request) {
        return request.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
    }

    private static HttpClientRequest disableChunkedTransfer(HttpClientRequest request) {
        return request.chunkedTransfer(false);
    }

    private static HttpClientRequest disableFailOnError(HttpClientRequest request) {
        return request.failOnClientError(false).failOnServerError(false);
    }

    private static String extractAccessToken(Map<String, String> payload) {
        String accessToken = payload.get(ACCESS_TOKEN);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Access Token: {}", (Object)accessToken);
            AbstractUaaTokenProvider.parseToken(accessToken).ifPresent(claims -> {
                LOGGER.debug("Access Token Issued At:  {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getIssuedAt()));
                LOGGER.debug("Access Token Expires At: {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getExpiration()));
            });
        }
        return String.format("%s %s", payload.get(TOKEN_TYPE), accessToken);
    }

    private static String getTokenUri(String root, String identityZoneId) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)root);
        if (identityZoneId != null) {
            builder.host(String.format("%s.%s", identityZoneId, builder.build().getHost()));
        }
        return builder.pathSegment(new String[]{"oauth", "token"}).build().encode().toUriString();
    }

    private static Optional<Claims> parseToken(String token) {
        try {
            String jws = token.substring(0, token.lastIndexOf(46) + 1);
            return Optional.of(Jwts.parser().parseClaimsJwt(jws).getBody());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.from(date.toInstant().atZone(UTC));
    }

    private HttpClientRequest addAuthorization(HttpClientRequest request) {
        String encoded = Base64.getEncoder().encodeToString(new AsciiString((CharSequence)this.getClientId()).concat((CharSequence)":").concat((CharSequence)this.getClientSecret()).toByteArray());
        return request.header((CharSequence)HttpHeaderNames.AUTHORIZATION, (CharSequence)String.format("Basic %s", encoded));
    }

    private Consumer<Map<String, String>> extractRefreshToken(ConnectionContext connectionContext) {
        return payload -> Optional.ofNullable(payload.get(REFRESH_TOKEN)).ifPresent(refreshToken -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Refresh Token: {}", refreshToken);
                AbstractUaaTokenProvider.parseToken(refreshToken).ifPresent(claims -> {
                    LOGGER.debug("Refresh Token Issued At:  {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getIssuedAt()));
                    LOGGER.debug("Refresh Token Expires At: {} UTC", (Object)AbstractUaaTokenProvider.toLocalDateTime(claims.getExpiration()));
                });
            }
            this.refreshTokens.put(connectionContext, (Mono<String>)Mono.just((Object)refreshToken));
            this.getRefreshTokenStream(connectionContext).onNext(refreshToken);
        });
    }

    private Function<Mono<HttpClientResponse>, Mono<String>> extractTokens(ConnectionContext connectionContext) {
        return inbound -> inbound.transform(JsonCodec.decode(connectionContext.getObjectMapper(), Map.class)).map(payload -> payload).doOnNext(this.extractRefreshToken(connectionContext)).map(AbstractUaaTokenProvider::extractAccessToken);
    }

    private ReplayProcessor<String> getRefreshTokenStream(ConnectionContext connectionContext) {
        return this.refreshTokenStreams.computeIfAbsent(connectionContext, c -> ReplayProcessor.create((int)1));
    }

    private Mono<HttpClientResponse> primaryToken(ConnectionContext connectionContext) {
        return this.requestToken(connectionContext, this::tokenRequestTransformer);
    }

    private Mono<HttpClientResponse> refreshToken(ConnectionContext connectionContext, String refreshToken) {
        return this.requestToken(connectionContext, this.refreshTokenGrantTokenRequestTransformer(refreshToken)).onErrorResume(t -> t instanceof UaaException && ((UaaException)t).getStatusCode() == HttpResponseStatus.UNAUTHORIZED.code(), t -> Mono.empty());
    }

    private Function<Mono<HttpClientRequest>, Mono<Void>> refreshTokenGrantTokenRequestTransformer(String refreshToken) {
        return outbound -> outbound.flatMap(request -> request.sendForm(form -> form.multipart(false).attr("client_id", this.getClientId()).attr("client_secret", this.getClientSecret()).attr("grant_type", REFRESH_TOKEN).attr(REFRESH_TOKEN, refreshToken)).then());
    }

    private Mono<HttpClientResponse> requestToken(ConnectionContext connectionContext, Function<Mono<HttpClientRequest>, Mono<Void>> tokenRequestTransformer) {
        return connectionContext.getRootProvider().getRoot(AUTHORIZATION_ENDPOINT, connectionContext).map(root -> AbstractUaaTokenProvider.getTokenUri(root, this.getIdentityZoneSubdomain())).flatMap(uri -> connectionContext.getHttpClient().post(uri, request -> Mono.just((Object)request).map(AbstractUaaTokenProvider::disableChunkedTransfer).map(AbstractUaaTokenProvider::disableFailOnError).map(this::addAuthorization).map(UserAgent::addUserAgent).map(AbstractUaaTokenProvider::addContentType).map(JsonCodec::addDecodeHeaders).transform(tokenRequestTransformer)).doOnSubscribe(NetworkLogging.post(uri)).transform(NetworkLogging.response(uri))).transform(ErrorPayloadMapper.uaa(connectionContext.getObjectMapper()));
    }

    private Mono<String> token(ConnectionContext connectionContext) {
        Mono cached = this.refreshTokens.getOrDefault(connectionContext, (Mono<String>)Mono.empty()).flatMap(refreshToken -> this.refreshToken(connectionContext, (String)refreshToken).doOnSubscribe(s -> LOGGER.debug("Negotiating using refresh token"))).switchIfEmpty(this.primaryToken(connectionContext).doOnSubscribe(s -> LOGGER.debug("Negotiating using token provider"))).transform(ErrorPayloadMapper.fallback()).transform(this.extractTokens(connectionContext));
        return connectionContext.getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache()).checkpoint();
    }
}

