/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import java.util.function.Function;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.uaa.IdentityZoneBuilder;
import org.cloudfoundry.reactor.uaa.VersionBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public abstract class AbstractUaaOperations
extends AbstractReactorOperations {
    private final ConnectionContext connectionContext;

    protected AbstractUaaOperations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
        this.connectionContext = connectionContext;
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doDelete(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> requestTransformer) {
        return this.doDelete(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)).transform(requestTransformer), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final Mono<HttpClientResponse> get(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final Mono<HttpClientResponse> get(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> requestTransformer) {
        return this.doGet(AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)).transform(requestTransformer), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> requestTransformer) {
        return this.doGet(responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)).transform(requestTransformer), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> patch(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPatch(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> requestTransformer) {
        return this.doPost(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)).transform(requestTransformer), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(requestPayload, responseType, AbstractUaaOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(AbstractUaaOperations.headerTransformer(requestPayload)), ErrorPayloadMapper.uaa(this.connectionContext.getObjectMapper()));
    }

    private static Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> headerTransformer(Object requestPayload) {
        return outbound -> outbound.map(request -> {
            IdentityZoneBuilder.augment(request, requestPayload);
            VersionBuilder.augment(request, requestPayload);
            return request;
        });
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            QueryBuilder.augment(builder, requestPayload);
            return builder;
        };
    }
}

