/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.authorizations;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.util.Optional;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.uaa.ResponseType;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.authorizations.AuthorizeByAuthorizationCodeGrantApiRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByAuthorizationCodeGrantBrowserRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByAuthorizationCodeGrantHybridRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByImplicitGrantBrowserRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithAuthorizationCodeGrantRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithIdTokenRequest;
import org.cloudfoundry.uaa.authorizations.AuthorizeByOpenIdWithImplicitGrantRequest;
import org.cloudfoundry.util.ExceptionUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;

public final class ReactorAuthorizations
extends AbstractUaaOperations
implements Authorizations {
    private static final AsciiString LOCATION = new AsciiString((CharSequence)"Location");

    public ReactorAuthorizations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<String> authorizationCodeGrantApi(AuthorizeByAuthorizationCodeGrantApiRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).flatMap(location -> {
            String candidate = (String)UriComponentsBuilder.fromUriString((String)location).build().getQueryParams().getFirst((Object)"code");
            return Optional.ofNullable(candidate).map(Mono::just).orElse(ExceptionUtils.illegalState((String)String.format("Parameter %s not in URI %s", "code", location), (Object[])new Object[0]));
        }).checkpoint();
    }

    public Mono<String> authorizationCodeGrantBrowser(AuthorizeByAuthorizationCodeGrantBrowserRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE}), (Mono<HttpClientRequest> outbound) -> outbound.map(ReactorAuthorizations::removeAuthorization)).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    public Mono<String> authorizationCodeGrantHybrid(AuthorizeByAuthorizationCodeGrantHybridRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE_AND_ID_TOKEN}), (Mono<HttpClientRequest> outbound) -> outbound.map(ReactorAuthorizations::removeAuthorization)).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    public Mono<String> implicitGrantBrowser(AuthorizeByImplicitGrantBrowserRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.TOKEN}), (Mono<HttpClientRequest> outbound) -> outbound.map(ReactorAuthorizations::removeAuthorization)).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    public Mono<String> openIdWithAuthorizationCodeAndIdToken(AuthorizeByOpenIdWithAuthorizationCodeGrantRequest request) {
        return this.get((Object)request, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.CODE_AND_ID_TOKEN}), (Mono<HttpClientRequest> outbound) -> outbound.map(ReactorAuthorizations::removeAuthorization)).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    public Mono<String> openIdWithIdToken(AuthorizeByOpenIdWithIdTokenRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    public Mono<String> openIdWithTokenAndIdToken(AuthorizeByOpenIdWithImplicitGrantRequest request) {
        return this.get(request, builder -> builder.pathSegment(new String[]{"oauth", "authorize"}).queryParam("response_type", new Object[]{ResponseType.TOKEN_AND_ID_TOKEN})).map(inbound -> inbound.responseHeaders().get((CharSequence)LOCATION)).checkpoint();
    }

    private static HttpClientRequest removeAuthorization(HttpClientRequest request) {
        request.requestHeaders().remove((CharSequence)HttpHeaderNames.AUTHORIZATION);
        return request;
    }
}

