/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.X509TrustManager;

final class CertificateCollectingTrustManager
implements X509TrustManager {
    private final X509TrustManager delegate;
    private final Object monitor = new Object();
    private X509Certificate[] collected;
    private Boolean trusted = Boolean.FALSE;

    CertificateCollectingTrustManager(X509TrustManager delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.collected != null) {
                throw new IllegalStateException("A certificate chain has already been collected.");
            }
            this.collected = chain;
            try {
                this.delegate.checkClientTrusted(chain, authType);
                this.trusted = Boolean.TRUE;
            }
            catch (CertificateException e) {
                this.trusted = Boolean.FALSE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.collected != null) {
                throw new IllegalStateException("A certificate chain has already been collected.");
            }
            this.collected = chain;
            try {
                this.delegate.checkServerTrusted(chain, authType);
                this.trusted = Boolean.TRUE;
            }
            catch (CertificateException e) {
                this.trusted = Boolean.FALSE;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate[] getCollectedCertificateChain() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.collected == null) {
                return null;
            }
            return Arrays.copyOf(this.collected, this.collected.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean isTrusted() {
        Object object = this.monitor;
        synchronized (object) {
            return this.trusted;
        }
    }
}

