/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudfoundry.reactor.util.UriVariable;

class UriVariablesRegistry {
    private final List<UriVariable> uriVariables = new ArrayList<UriVariable>();

    UriVariablesRegistry() {
    }

    Map<String, Object> getUriVariablesMap() {
        return this.uriVariables.stream().collect(Collectors.toMap(UriVariable::getKey, UriVariable::getValue));
    }

    UriVariable register(Object value) {
        UriVariable uriVariable = UriVariable.of(this.getNextUriVariableKey(), value);
        this.uriVariables.add(uriVariable);
        return uriVariable;
    }

    private String getNextUriVariableKey() {
        return Integer.toString(this.uriVariables.size());
    }
}

