/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.applications._ListApplicationServiceBindingsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListApplicationServiceBindingsRequest", generator="Immutables")
public final class ListApplicationServiceBindingsRequest
extends _ListApplicationServiceBindingsRequest {
    private final String applicationId;
    @Nullable
    private final List<String> serviceInstanceIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListApplicationServiceBindingsRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.serviceInstanceIds = builder.serviceInstanceIds == null ? null : ListApplicationServiceBindingsRequest.createUnmodifiableList(true, builder.serviceInstanceIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @Nullable
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationServiceBindingsRequest && this.equalTo((ListApplicationServiceBindingsRequest)another);
    }

    private boolean equalTo(ListApplicationServiceBindingsRequest another) {
        return this.applicationId.equals(another.applicationId) && Objects.equals(this.serviceInstanceIds, another.serviceInstanceIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.serviceInstanceIds);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListApplicationServiceBindingsRequest{applicationId=" + this.applicationId + ", serviceInstanceIds=" + this.serviceInstanceIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListApplicationServiceBindingsRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private List<String> serviceInstanceIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListApplicationServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListApplicationServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListApplicationServiceBindingsRequest) {
                instance = (_ListApplicationServiceBindingsRequest)object;
                this.applicationId(((_ListApplicationServiceBindingsRequest)instance).getApplicationId());
                List<String> serviceInstanceIdsValue = ((_ListApplicationServiceBindingsRequest)instance).getServiceInstanceIds();
                if (serviceInstanceIdsValue != null) {
                    this.addAllServiceInstanceIds(serviceInstanceIdsValue);
                }
            }
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstanceId(String element) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            return this;
        }

        public final Builder serviceInstanceIds(String ... elements) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.serviceInstanceIds = null;
                return this;
            }
            this.serviceInstanceIds = new ArrayList<String>();
            return this.addAllServiceInstanceIds(elements);
        }

        public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "serviceInstanceIds element");
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationServiceBindingsRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListApplicationServiceBindingsRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationServiceBindingsRequest, some of required attributes are not set " + attributes;
        }
    }
}

