/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.organizations._ListOrganizationsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListOrganizationsRequest", generator="Immutables")
public final class ListOrganizationsRequest
extends _ListOrganizationsRequest {
    @Nullable
    private final List<String> auditorIds;
    @Nullable
    private final List<String> billingManagerIds;
    @Nullable
    private final List<String> managerIds;
    @Nullable
    private final List<String> names;
    @Nullable
    private final List<String> spaceIds;
    @Nullable
    private final List<String> statuses;
    @Nullable
    private final List<String> userIds;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListOrganizationsRequest(Builder builder) {
        this.auditorIds = builder.auditorIds == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.auditorIds);
        this.billingManagerIds = builder.billingManagerIds == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.billingManagerIds);
        this.managerIds = builder.managerIds == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.managerIds);
        this.names = builder.names == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.names);
        this.spaceIds = builder.spaceIds == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.spaceIds);
        this.statuses = builder.statuses == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.statuses);
        this.userIds = builder.userIds == null ? null : ListOrganizationsRequest.createUnmodifiableList(true, builder.userIds);
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getAuditorIds() {
        return this.auditorIds;
    }

    @Override
    @Nullable
    public List<String> getBillingManagerIds() {
        return this.billingManagerIds;
    }

    @Override
    @Nullable
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    @Override
    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    @Nullable
    public List<String> getStatuses() {
        return this.statuses;
    }

    @Override
    @Nullable
    public List<String> getUserIds() {
        return this.userIds;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListOrganizationsRequest && this.equalTo((ListOrganizationsRequest)another);
    }

    private boolean equalTo(ListOrganizationsRequest another) {
        return Objects.equals(this.auditorIds, another.auditorIds) && Objects.equals(this.billingManagerIds, another.billingManagerIds) && Objects.equals(this.managerIds, another.managerIds) && Objects.equals(this.names, another.names) && Objects.equals(this.spaceIds, another.spaceIds) && Objects.equals(this.statuses, another.statuses) && Objects.equals(this.userIds, another.userIds) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.auditorIds);
        h += (h << 5) + Objects.hashCode(this.billingManagerIds);
        h += (h << 5) + Objects.hashCode(this.managerIds);
        h += (h << 5) + Objects.hashCode(this.names);
        h += (h << 5) + Objects.hashCode(this.spaceIds);
        h += (h << 5) + Objects.hashCode(this.statuses);
        h += (h << 5) + Objects.hashCode(this.userIds);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListOrganizationsRequest{auditorIds=" + this.auditorIds + ", billingManagerIds=" + this.billingManagerIds + ", managerIds=" + this.managerIds + ", names=" + this.names + ", spaceIds=" + this.spaceIds + ", statuses=" + this.statuses + ", userIds=" + this.userIds + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListOrganizationsRequest", generator="Immutables")
    public static final class Builder {
        private List<String> auditorIds = null;
        private List<String> billingManagerIds = null;
        private List<String> managerIds = null;
        private List<String> names = null;
        private List<String> spaceIds = null;
        private List<String> statuses = null;
        private List<String> userIds = null;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListOrganizationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListOrganizationsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListOrganizationsRequest) {
                List<String> spaceIdsValue;
                List<String> billingManagerIdsValue;
                List<String> auditorIdsValue;
                List<String> statusesValue;
                List<String> userIdsValue;
                List<String> namesValue;
                instance = (_ListOrganizationsRequest)object;
                List<String> managerIdsValue = ((_ListOrganizationsRequest)instance).getManagerIds();
                if (managerIdsValue != null) {
                    this.addAllManagerIds(managerIdsValue);
                }
                if ((namesValue = ((_ListOrganizationsRequest)instance).getNames()) != null) {
                    this.addAllNames(namesValue);
                }
                if ((userIdsValue = ((_ListOrganizationsRequest)instance).getUserIds()) != null) {
                    this.addAllUserIds(userIdsValue);
                }
                if ((statusesValue = ((_ListOrganizationsRequest)instance).getStatuses()) != null) {
                    this.addAllStatuses(statusesValue);
                }
                if ((auditorIdsValue = ((_ListOrganizationsRequest)instance).getAuditorIds()) != null) {
                    this.addAllAuditorIds(auditorIdsValue);
                }
                if ((billingManagerIdsValue = ((_ListOrganizationsRequest)instance).getBillingManagerIds()) != null) {
                    this.addAllBillingManagerIds(billingManagerIdsValue);
                }
                if ((spaceIdsValue = ((_ListOrganizationsRequest)instance).getSpaceIds()) != null) {
                    this.addAllSpaceIds(spaceIdsValue);
                }
            }
        }

        public final Builder auditorId(String element) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList<String>();
            }
            this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
            return this;
        }

        public final Builder auditorIds(String ... elements) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
            }
            return this;
        }

        public final Builder auditorIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.auditorIds = null;
                return this;
            }
            this.auditorIds = new ArrayList<String>();
            return this.addAllAuditorIds(elements);
        }

        public final Builder addAllAuditorIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "auditorIds element");
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
            }
            return this;
        }

        public final Builder billingManagerId(String element) {
            if (this.billingManagerIds == null) {
                this.billingManagerIds = new ArrayList<String>();
            }
            this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
            return this;
        }

        public final Builder billingManagerIds(String ... elements) {
            if (this.billingManagerIds == null) {
                this.billingManagerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
            }
            return this;
        }

        public final Builder billingManagerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.billingManagerIds = null;
                return this;
            }
            this.billingManagerIds = new ArrayList<String>();
            return this.addAllBillingManagerIds(elements);
        }

        public final Builder addAllBillingManagerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "billingManagerIds element");
            if (this.billingManagerIds == null) {
                this.billingManagerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
            }
            return this;
        }

        public final Builder managerId(String element) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            return this;
        }

        public final Builder managerIds(String ... elements) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            }
            return this;
        }

        public final Builder managerIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.managerIds = null;
                return this;
            }
            this.managerIds = new ArrayList<String>();
            return this.addAllManagerIds(elements);
        }

        public final Builder addAllManagerIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "managerIds element");
            if (this.managerIds == null) {
                this.managerIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.names = null;
                return this;
            }
            this.names = new ArrayList<String>();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "names element");
            if (this.names == null) {
                this.names = new ArrayList<String>();
            }
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.spaceIds = null;
                return this;
            }
            this.spaceIds = new ArrayList<String>();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "spaceIds element");
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder status(String element) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<String>();
            }
            this.statuses.add(Objects.requireNonNull(element, "statuses element"));
            return this;
        }

        public final Builder statuses(String ... elements) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<String>();
            }
            for (String element : elements) {
                this.statuses.add(Objects.requireNonNull(element, "statuses element"));
            }
            return this;
        }

        public final Builder statuses(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.statuses = null;
                return this;
            }
            this.statuses = new ArrayList<String>();
            return this.addAllStatuses(elements);
        }

        public final Builder addAllStatuses(Iterable<String> elements) {
            Objects.requireNonNull(elements, "statuses element");
            if (this.statuses == null) {
                this.statuses = new ArrayList<String>();
            }
            for (String element : elements) {
                this.statuses.add(Objects.requireNonNull(element, "statuses element"));
            }
            return this;
        }

        public final Builder userId(String element) {
            if (this.userIds == null) {
                this.userIds = new ArrayList<String>();
            }
            this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            return this;
        }

        public final Builder userIds(String ... elements) {
            if (this.userIds == null) {
                this.userIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder userIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.userIds = null;
                return this;
            }
            this.userIds = new ArrayList<String>();
            return this.addAllUserIds(elements);
        }

        public final Builder addAllUserIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "userIds element");
            if (this.userIds == null) {
                this.userIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationsRequest build() {
            return new ListOrganizationsRequest(this);
        }
    }
}

