/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;
import org.cloudfoundry.uaa.users.Email;
import org.cloudfoundry.uaa.users.Name;
import org.cloudfoundry.uaa.users.PhoneNumber;
import org.cloudfoundry.uaa.users._UpdateUserRequest;
import org.immutables.value.Generated;

@Generated(from="_UpdateUserRequest", generator="Immutables")
public final class UpdateUserRequest
extends _UpdateUserRequest {
    private final String version;
    @Nullable
    private final Boolean active;
    private final List<Email> emails;
    @Nullable
    private final String externalId;
    private final String id;
    private final Name name;
    @Nullable
    private final String origin;
    private final List<PhoneNumber> phoneNumbers;
    private final String userName;
    @Nullable
    private final Boolean verified;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private UpdateUserRequest(Builder builder) {
        this.version = builder.version;
        this.active = builder.active;
        this.emails = UpdateUserRequest.createUnmodifiableList(true, builder.emails);
        this.externalId = builder.externalId;
        this.id = builder.id;
        this.name = builder.name;
        this.origin = builder.origin;
        this.phoneNumbers = UpdateUserRequest.createUnmodifiableList(true, builder.phoneNumbers);
        this.userName = builder.userName;
        this.verified = builder.verified;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="version")
    @JsonIgnore
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="active")
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="emails")
    public List<Email> getEmails() {
        return this.emails;
    }

    @Override
    @JsonProperty(value="externalId")
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty(value="id")
    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Name getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="origin")
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="phoneNumbers")
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Override
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @Override
    @JsonProperty(value="verified")
    @Nullable
    public Boolean getVerified() {
        return this.verified;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateUserRequest && this.equalTo((UpdateUserRequest)another);
    }

    private boolean equalTo(UpdateUserRequest another) {
        return this.version.equals(another.version) && Objects.equals(this.active, another.active) && this.emails.equals(another.emails) && Objects.equals(this.externalId, another.externalId) && this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.origin, another.origin) && this.phoneNumbers.equals(another.phoneNumbers) && this.userName.equals(another.userName) && Objects.equals(this.verified, another.verified) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + this.emails.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + this.phoneNumbers.hashCode();
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + Objects.hashCode(this.verified);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "UpdateUserRequest{version=" + this.version + ", active=" + this.active + ", emails=" + this.emails + ", externalId=" + this.externalId + ", id=" + this.id + ", name=" + this.name + ", origin=" + this.origin + ", phoneNumbers=" + this.phoneNumbers + ", userName=" + this.userName + ", verified=" + this.verified + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UpdateUserRequest fromJson(Json json) {
        Builder builder = UpdateUserRequest.builder();
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.emails != null) {
            builder.addAllEmails(json.emails);
        }
        if (json.externalId != null) {
            builder.externalId(json.externalId);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.phoneNumbers != null) {
            builder.addAllPhoneNumbers(json.phoneNumbers);
        }
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    private static UpdateUserRequest validate(UpdateUserRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UpdateUserRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_USER_NAME = 8L;
        private long initBits = 15L;
        private String version;
        private Boolean active;
        private List<Email> emails = new ArrayList<Email>();
        private String externalId;
        private String id;
        private Name name;
        private String origin;
        private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
        private String userName;
        private Boolean verified;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Versioned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_UpdateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof Versioned) {
                instance = (Versioned)object;
                if ((bits & 1L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 1L;
                }
            }
            if (object instanceof _UpdateUserRequest) {
                String externalIdValue;
                Boolean activeValue;
                instance = (_UpdateUserRequest)object;
                this.addAllEmails(((_UpdateUserRequest)instance).getEmails());
                String originValue = ((_UpdateUserRequest)instance).getOrigin();
                if (originValue != null) {
                    this.origin(originValue);
                }
                this.name(((_UpdateUserRequest)instance).getName());
                Boolean verifiedValue = ((_UpdateUserRequest)instance).getVerified();
                if (verifiedValue != null) {
                    this.verified(verifiedValue);
                }
                if ((activeValue = ((_UpdateUserRequest)instance).getActive()) != null) {
                    this.active(activeValue);
                }
                if ((externalIdValue = ((_UpdateUserRequest)instance).getExternalId()) != null) {
                    this.externalId(externalIdValue);
                }
                this.id(((_UpdateUserRequest)instance).getId());
                this.userName(((_UpdateUserRequest)instance).getUserName());
                if ((bits & 1L) == 0L) {
                    this.version(((_UpdateUserRequest)instance).getVersion());
                    bits |= 1L;
                }
                this.addAllPhoneNumbers(((_UpdateUserRequest)instance).getPhoneNumbers());
            }
        }

        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder email(Email element) {
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder emails(Email ... elements) {
            for (Email element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder emails(Iterable<? extends Email> elements) {
            this.emails.clear();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<? extends Email> elements) {
            for (Email email : elements) {
                this.emails.add(Objects.requireNonNull(email, "emails element"));
            }
            return this;
        }

        public final Builder externalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(Name name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        public final Builder phoneNumber(PhoneNumber element) {
            this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            return this;
        }

        public final Builder phoneNumbers(PhoneNumber ... elements) {
            for (PhoneNumber element : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder phoneNumbers(Iterable<? extends PhoneNumber> elements) {
            this.phoneNumbers.clear();
            return this.addAllPhoneNumbers(elements);
        }

        public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
            for (PhoneNumber phoneNumber : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(phoneNumber, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder verified(@Nullable Boolean verified) {
            this.verified = verified;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public UpdateUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return UpdateUserRequest.validate(new UpdateUserRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("userName");
            }
            return "Cannot build UpdateUserRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_UpdateUserRequest", generator="Immutables")
    static final class Json
    extends _UpdateUserRequest {
        String version;
        Boolean active;
        List<Email> emails = Collections.emptyList();
        String externalId;
        String id;
        Name name;
        String origin;
        List<PhoneNumber> phoneNumbers = Collections.emptyList();
        String userName;
        Boolean verified;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="version")
        @JsonIgnore
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty(value="active")
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="emails")
        public void setEmails(List<Email> emails) {
            this.emails = emails;
        }

        @JsonProperty(value="externalId")
        public void setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty(value="id")
        @JsonIgnore
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(Name name) {
            this.name = name;
        }

        @JsonProperty(value="origin")
        public void setOrigin(@Nullable String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="phoneNumbers")
        public void setPhoneNumbers(List<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @JsonProperty(value="verified")
        public void setVerified(@Nullable Boolean verified) {
            this.verified = verified;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Email> getEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Name getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PhoneNumber> getPhoneNumbers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getVerified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

