package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity representing Docker Credentials
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DockerCredentials"})
public final class DockerCredentials extends org.cloudfoundry.client.v2.applications._DockerCredentials {
  private final @Nullable String password;
  private final @Nullable String username;

  private DockerCredentials(DockerCredentials.Builder builder) {
    this.password = builder.password;
    this.username = builder.username;
  }

  /**
   * The password
   */
  @JsonProperty("password")
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The username
   */
  @JsonProperty("username")
  @Override
  public @Nullable String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code DockerCredentials} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DockerCredentials
        && equalTo((DockerCredentials) another);
  }

  private boolean equalTo(DockerCredentials another) {
    return Objects.equals(password, another.password)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code DockerCredentials} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DockerCredentials{"
        + "password=" + password
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._DockerCredentials {
    String password;
    String username;
    @JsonProperty("password")
    public void setPassword(@Nullable String password) {
      this.password = password;
    }
    @JsonProperty("username")
    public void setUsername(@Nullable String username) {
      this.username = username;
    }
    @Override
    public String getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static DockerCredentials fromJson(Json json) {
    DockerCredentials.Builder builder = DockerCredentials.builder();
    if (json.password != null) {
      builder.password(json.password);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link DockerCredentials DockerCredentials}.
   * @return A new DockerCredentials builder
   */
  public static DockerCredentials.Builder builder() {
    return new DockerCredentials.Builder();
  }

  /**
   * Builds instances of type {@link DockerCredentials DockerCredentials}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String password;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DockerCredentials} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DockerCredentials instance) {
      return from((_DockerCredentials) instance);
    }

    /**
     * Copy abstract value type {@code _DockerCredentials} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DockerCredentials instance) {
      Objects.requireNonNull(instance, "instance");
      String passwordValue = instance.getPassword();
      if (passwordValue != null) {
        password(passwordValue);
      }
      String usernameValue = instance.getUsername();
      if (usernameValue != null) {
        username(usernameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DockerCredentials#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("password")
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Initializes the value for the {@link _DockerCredentials#getUsername() username} attribute.
     * @param username The value for username (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("username")
    public final Builder username(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Builds a new {@link DockerCredentials DockerCredentials}.
     * @return An immutable instance of DockerCredentials
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DockerCredentials build() {
      return new DockerCredentials(this);
    }
  }
}
