package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Manager with the Organization by Username operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssociateOrganizationManagerByUsernameRequest"})
public final class AssociateOrganizationManagerByUsernameRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationManagerByUsernameRequest {
  private final String organizationId;
  private final String username;

  private AssociateOrganizationManagerByUsernameRequest(AssociateOrganizationManagerByUsernameRequest.Builder builder) {
    this.organizationId = builder.organizationId;
    this.username = builder.username;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationManagerByUsernameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationManagerByUsernameRequest
        && equalTo((AssociateOrganizationManagerByUsernameRequest) another);
  }

  private boolean equalTo(AssociateOrganizationManagerByUsernameRequest another) {
    return organizationId.equals(another.organizationId)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code organizationId}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + organizationId.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationManagerByUsernameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationManagerByUsernameRequest{"
        + "organizationId=" + organizationId
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationManagerByUsernameRequest AssociateOrganizationManagerByUsernameRequest}.
   * @return A new AssociateOrganizationManagerByUsernameRequest builder
   */
  public static AssociateOrganizationManagerByUsernameRequest.Builder builder() {
    return new AssociateOrganizationManagerByUsernameRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationManagerByUsernameRequest AssociateOrganizationManagerByUsernameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_ID = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationId;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationManagerByUsernameRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationManagerByUsernameRequest instance) {
      return from((_AssociateOrganizationManagerByUsernameRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationManagerByUsernameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationManagerByUsernameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationId(instance.getOrganizationId());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationManagerByUsernameRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationManagerByUsernameRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationManagerByUsernameRequest AssociateOrganizationManagerByUsernameRequest}.
     * @return An immutable instance of AssociateOrganizationManagerByUsernameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationManagerByUsernameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationManagerByUsernameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build AssociateOrganizationManagerByUsernameRequest, some of required attributes are not set " + attributes;
    }
  }
}
