package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Route Mappings operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListRouteMappingsRequest"})
public final class ListRouteMappingsRequest
    extends org.cloudfoundry.client.v2.routemappings._ListRouteMappingsRequest {
  private final @Nullable List<String> applicationIds;
  private final @Nullable List<String> routeIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListRouteMappingsRequest(ListRouteMappingsRequest.Builder builder) {
    this.applicationIds = builder.applicationIds == null ? null : createUnmodifiableList(true, builder.applicationIds);
    this.routeIds = builder.routeIds == null ? null : createUnmodifiableList(true, builder.routeIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The ids of the applications
   */
  @Override
  public @Nullable List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The ids of the routes
   */
  @Override
  public @Nullable List<String> getRouteIds() {
    return routeIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListRouteMappingsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRouteMappingsRequest
        && equalTo((ListRouteMappingsRequest) another);
  }

  private boolean equalTo(ListRouteMappingsRequest another) {
    return Objects.equals(applicationIds, another.applicationIds)
        && Objects.equals(routeIds, another.routeIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code routeIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationIds);
    h += (h << 5) + Objects.hashCode(routeIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRouteMappingsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRouteMappingsRequest{"
        + "applicationIds=" + applicationIds
        + ", routeIds=" + routeIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListRouteMappingsRequest ListRouteMappingsRequest}.
   * @return A new ListRouteMappingsRequest builder
   */
  public static ListRouteMappingsRequest.Builder builder() {
    return new ListRouteMappingsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRouteMappingsRequest ListRouteMappingsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> applicationIds = null;
    private List<String> routeIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRouteMappingsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRouteMappingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRouteMappingsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListRouteMappingsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.routemappings._ListRouteMappingsRequest) {
        org.cloudfoundry.client.v2.routemappings._ListRouteMappingsRequest instance = (org.cloudfoundry.client.v2.routemappings._ListRouteMappingsRequest) object;
        List<String> routeIdsValue = instance.getRouteIds();
        if (routeIdsValue != null) {
          addAllRouteIds(routeIdsValue);
        }
        List<String> applicationIdsValue = instance.getApplicationIds();
        if (applicationIdsValue != null) {
          addAllApplicationIds(applicationIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListRouteMappingsRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRouteMappingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String... elements) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRouteMappingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.applicationIds = null;
        return this;
      }
      this.applicationIds = new ArrayList<String>();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link _ListRouteMappingsRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "applicationIds element");
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListRouteMappingsRequest#getRouteIds() routeIds} list.
     * @param element A routeIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String element) {
      if (this.routeIds == null) {
        this.routeIds = new ArrayList<String>();
      }
      this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRouteMappingsRequest#getRouteIds() routeIds} list.
     * @param elements An array of routeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String... elements) {
      if (this.routeIds == null) {
        this.routeIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRouteMappingsRequest#getRouteIds() routeIds} list.
     * @param elements An iterable of routeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.routeIds = null;
        return this;
      }
      this.routeIds = new ArrayList<String>();
      return addAllRouteIds(elements);
    }

    /**
     * Adds elements to {@link _ListRouteMappingsRequest#getRouteIds() routeIds} list.
     * @param elements An iterable of routeIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRouteIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "routeIds element");
      if (this.routeIds == null) {
        this.routeIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.routeIds.add(Objects.requireNonNull(element, "routeIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRouteMappingsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRouteMappingsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListRouteMappingsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListRouteMappingsRequest ListRouteMappingsRequest}.
     * @return An immutable instance of ListRouteMappingsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRouteMappingsRequest build() {
      return new ListRouteMappingsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
