package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Service Keys
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceKeyEntity"})
public final class ServiceKeyEntity extends org.cloudfoundry.client.v2.servicekeys._ServiceKeyEntity {
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String name;
  private final @Nullable String serviceInstanceId;
  private final @Nullable String serviceInstanceUrl;

  private ServiceKeyEntity(ServiceKeyEntity.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.name = builder.name;
    this.serviceInstanceId = builder.serviceInstanceId;
    this.serviceInstanceUrl = builder.serviceInstanceUrl;
  }

  /**
   * The credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service instance id
   */
  @JsonProperty("service_instance_guid")
  @Override
  public @Nullable String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service instance url
   */
  @JsonProperty("service_instance_url")
  @Override
  public @Nullable String getServiceInstanceUrl() {
    return serviceInstanceUrl;
  }

  /**
   * This instance is equal to all instances of {@code ServiceKeyEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceKeyEntity
        && equalTo((ServiceKeyEntity) another);
  }

  private boolean equalTo(ServiceKeyEntity another) {
    return Objects.equals(credentials, another.credentials)
        && Objects.equals(name, another.name)
        && Objects.equals(serviceInstanceId, another.serviceInstanceId)
        && Objects.equals(serviceInstanceUrl, another.serviceInstanceUrl);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code name}, {@code serviceInstanceId}, {@code serviceInstanceUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(serviceInstanceId);
    h += (h << 5) + Objects.hashCode(serviceInstanceUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceKeyEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceKeyEntity{"
        + "credentials=" + credentials
        + ", name=" + name
        + ", serviceInstanceId=" + serviceInstanceId
        + ", serviceInstanceUrl=" + serviceInstanceUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.servicekeys._ServiceKeyEntity {
    Map<String, Object> credentials = null;
    String name;
    String serviceInstanceId;
    String serviceInstanceUrl;
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("service_instance_guid")
    public void setServiceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @JsonProperty("service_instance_url")
    public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceKeyEntity fromJson(Json json) {
    ServiceKeyEntity.Builder builder = ServiceKeyEntity.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    if (json.serviceInstanceUrl != null) {
      builder.serviceInstanceUrl(json.serviceInstanceUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceKeyEntity ServiceKeyEntity}.
   * @return A new ServiceKeyEntity builder
   */
  public static ServiceKeyEntity.Builder builder() {
    return new ServiceKeyEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServiceKeyEntity ServiceKeyEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> credentials = null;
    private String name;
    private String serviceInstanceId;
    private String serviceInstanceUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceKeyEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceKeyEntity instance) {
      return from((_ServiceKeyEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceKeyEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceKeyEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String serviceInstanceIdValue = instance.getServiceInstanceId();
      if (serviceInstanceIdValue != null) {
        serviceInstanceId(serviceInstanceIdValue);
      }
      String serviceInstanceUrlValue = instance.getServiceInstanceUrl();
      if (serviceInstanceUrlValue != null) {
        serviceInstanceUrl(serviceInstanceUrlValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceKeyEntity#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceKeyEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceKeyEntity#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceKeyEntity#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceKeyEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceKeyEntity#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_guid")
    public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceKeyEntity#getServiceInstanceUrl() serviceInstanceUrl} attribute.
     * @param serviceInstanceUrl The value for serviceInstanceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_url")
    public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
      return this;
    }

    /**
     * Builds a new {@link ServiceKeyEntity ServiceKeyEntity}.
     * @return An immutable instance of ServiceKeyEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceKeyEntity build() {
      return new ServiceKeyEntity(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
