package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the User Summary resource
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UserSummaryEntity"})
public final class UserSummaryEntity extends org.cloudfoundry.client.v2.users._UserSummaryEntity {
  private final @Nullable List<UserOrganizationResource> auditedOrganizations;
  private final @Nullable List<UserSpaceResource> auditedSpaces;
  private final @Nullable List<UserOrganizationResource> billingManagedOrganizations;
  private final @Nullable List<UserOrganizationResource> managedOrganizations;
  private final @Nullable List<UserSpaceResource> managedSpaces;
  private final @Nullable List<UserOrganizationResource> organizations;
  private final @Nullable List<UserSpaceResource> spaces;

  private UserSummaryEntity(UserSummaryEntity.Builder builder) {
    this.auditedOrganizations = builder.auditedOrganizations == null ? null : createUnmodifiableList(true, builder.auditedOrganizations);
    this.auditedSpaces = builder.auditedSpaces == null ? null : createUnmodifiableList(true, builder.auditedSpaces);
    this.billingManagedOrganizations = builder.billingManagedOrganizations == null ? null : createUnmodifiableList(true, builder.billingManagedOrganizations);
    this.managedOrganizations = builder.managedOrganizations == null ? null : createUnmodifiableList(true, builder.managedOrganizations);
    this.managedSpaces = builder.managedSpaces == null ? null : createUnmodifiableList(true, builder.managedSpaces);
    this.organizations = builder.organizations == null ? null : createUnmodifiableList(true, builder.organizations);
    this.spaces = builder.spaces == null ? null : createUnmodifiableList(true, builder.spaces);
  }

  /**
   * The audited organizations
   */
  @JsonProperty("audited_organizations")
  @Override
  public @Nullable List<UserOrganizationResource> getAuditedOrganizations() {
    return auditedOrganizations;
  }

  /**
   * The audited spaces
   */
  @JsonProperty("audited_spaces")
  @Override
  public @Nullable List<UserSpaceResource> getAuditedSpaces() {
    return auditedSpaces;
  }

  /**
   * The billing managed organizations
   */
  @JsonProperty("billing_managed_organizations")
  @Override
  public @Nullable List<UserOrganizationResource> getBillingManagedOrganizations() {
    return billingManagedOrganizations;
  }

  /**
   * The managed organizations
   */
  @JsonProperty("managed_organizations")
  @Override
  public @Nullable List<UserOrganizationResource> getManagedOrganizations() {
    return managedOrganizations;
  }

  /**
   * The managed spaces
   */
  @JsonProperty("managed_spaces")
  @Override
  public @Nullable List<UserSpaceResource> getManagedSpaces() {
    return managedSpaces;
  }

  /**
   * The developer organizations
   */
  @JsonProperty("organizations")
  @Override
  public @Nullable List<UserOrganizationResource> getOrganizations() {
    return organizations;
  }

  /**
   * The developer spaces
   */
  @JsonProperty("spaces")
  @Override
  public @Nullable List<UserSpaceResource> getSpaces() {
    return spaces;
  }

  /**
   * This instance is equal to all instances of {@code UserSummaryEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserSummaryEntity
        && equalTo((UserSummaryEntity) another);
  }

  private boolean equalTo(UserSummaryEntity another) {
    return Objects.equals(auditedOrganizations, another.auditedOrganizations)
        && Objects.equals(auditedSpaces, another.auditedSpaces)
        && Objects.equals(billingManagedOrganizations, another.billingManagedOrganizations)
        && Objects.equals(managedOrganizations, another.managedOrganizations)
        && Objects.equals(managedSpaces, another.managedSpaces)
        && Objects.equals(organizations, another.organizations)
        && Objects.equals(spaces, another.spaces);
  }

  /**
   * Computes a hash code from attributes: {@code auditedOrganizations}, {@code auditedSpaces}, {@code billingManagedOrganizations}, {@code managedOrganizations}, {@code managedSpaces}, {@code organizations}, {@code spaces}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(auditedOrganizations);
    h += (h << 5) + Objects.hashCode(auditedSpaces);
    h += (h << 5) + Objects.hashCode(billingManagedOrganizations);
    h += (h << 5) + Objects.hashCode(managedOrganizations);
    h += (h << 5) + Objects.hashCode(managedSpaces);
    h += (h << 5) + Objects.hashCode(organizations);
    h += (h << 5) + Objects.hashCode(spaces);
    return h;
  }

  /**
   * Prints the immutable value {@code UserSummaryEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserSummaryEntity{"
        + "auditedOrganizations=" + auditedOrganizations
        + ", auditedSpaces=" + auditedSpaces
        + ", billingManagedOrganizations=" + billingManagedOrganizations
        + ", managedOrganizations=" + managedOrganizations
        + ", managedSpaces=" + managedSpaces
        + ", organizations=" + organizations
        + ", spaces=" + spaces
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.users._UserSummaryEntity {
    List<UserOrganizationResource> auditedOrganizations = null;
    List<UserSpaceResource> auditedSpaces = null;
    List<UserOrganizationResource> billingManagedOrganizations = null;
    List<UserOrganizationResource> managedOrganizations = null;
    List<UserSpaceResource> managedSpaces = null;
    List<UserOrganizationResource> organizations = null;
    List<UserSpaceResource> spaces = null;
    @JsonProperty("audited_organizations")
    public void setAuditedOrganizations(@Nullable List<UserOrganizationResource> auditedOrganizations) {
      this.auditedOrganizations = auditedOrganizations;
    }
    @JsonProperty("audited_spaces")
    public void setAuditedSpaces(@Nullable List<UserSpaceResource> auditedSpaces) {
      this.auditedSpaces = auditedSpaces;
    }
    @JsonProperty("billing_managed_organizations")
    public void setBillingManagedOrganizations(@Nullable List<UserOrganizationResource> billingManagedOrganizations) {
      this.billingManagedOrganizations = billingManagedOrganizations;
    }
    @JsonProperty("managed_organizations")
    public void setManagedOrganizations(@Nullable List<UserOrganizationResource> managedOrganizations) {
      this.managedOrganizations = managedOrganizations;
    }
    @JsonProperty("managed_spaces")
    public void setManagedSpaces(@Nullable List<UserSpaceResource> managedSpaces) {
      this.managedSpaces = managedSpaces;
    }
    @JsonProperty("organizations")
    public void setOrganizations(@Nullable List<UserOrganizationResource> organizations) {
      this.organizations = organizations;
    }
    @JsonProperty("spaces")
    public void setSpaces(@Nullable List<UserSpaceResource> spaces) {
      this.spaces = spaces;
    }
    @Override
    public List<UserOrganizationResource> getAuditedOrganizations() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserSpaceResource> getAuditedSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserOrganizationResource> getBillingManagedOrganizations() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserOrganizationResource> getManagedOrganizations() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserSpaceResource> getManagedSpaces() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserOrganizationResource> getOrganizations() { throw new UnsupportedOperationException(); }
    @Override
    public List<UserSpaceResource> getSpaces() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserSummaryEntity fromJson(Json json) {
    UserSummaryEntity.Builder builder = UserSummaryEntity.builder();
    if (json.auditedOrganizations != null) {
      builder.addAllAuditedOrganizations(json.auditedOrganizations);
    }
    if (json.auditedSpaces != null) {
      builder.addAllAuditedSpaces(json.auditedSpaces);
    }
    if (json.billingManagedOrganizations != null) {
      builder.addAllBillingManagedOrganizations(json.billingManagedOrganizations);
    }
    if (json.managedOrganizations != null) {
      builder.addAllManagedOrganizations(json.managedOrganizations);
    }
    if (json.managedSpaces != null) {
      builder.addAllManagedSpaces(json.managedSpaces);
    }
    if (json.organizations != null) {
      builder.addAllOrganizations(json.organizations);
    }
    if (json.spaces != null) {
      builder.addAllSpaces(json.spaces);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserSummaryEntity UserSummaryEntity}.
   * @return A new UserSummaryEntity builder
   */
  public static UserSummaryEntity.Builder builder() {
    return new UserSummaryEntity.Builder();
  }

  /**
   * Builds instances of type {@link UserSummaryEntity UserSummaryEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<UserOrganizationResource> auditedOrganizations = null;
    private List<UserSpaceResource> auditedSpaces = null;
    private List<UserOrganizationResource> billingManagedOrganizations = null;
    private List<UserOrganizationResource> managedOrganizations = null;
    private List<UserSpaceResource> managedSpaces = null;
    private List<UserOrganizationResource> organizations = null;
    private List<UserSpaceResource> spaces = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserSummaryEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserSummaryEntity instance) {
      return from((_UserSummaryEntity) instance);
    }

    /**
     * Copy abstract value type {@code _UserSummaryEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserSummaryEntity instance) {
      Objects.requireNonNull(instance, "instance");
      List<UserOrganizationResource> auditedOrganizationsValue = instance.getAuditedOrganizations();
      if (auditedOrganizationsValue != null) {
        addAllAuditedOrganizations(auditedOrganizationsValue);
      }
      List<UserSpaceResource> auditedSpacesValue = instance.getAuditedSpaces();
      if (auditedSpacesValue != null) {
        addAllAuditedSpaces(auditedSpacesValue);
      }
      List<UserOrganizationResource> billingManagedOrganizationsValue = instance.getBillingManagedOrganizations();
      if (billingManagedOrganizationsValue != null) {
        addAllBillingManagedOrganizations(billingManagedOrganizationsValue);
      }
      List<UserOrganizationResource> managedOrganizationsValue = instance.getManagedOrganizations();
      if (managedOrganizationsValue != null) {
        addAllManagedOrganizations(managedOrganizationsValue);
      }
      List<UserSpaceResource> managedSpacesValue = instance.getManagedSpaces();
      if (managedSpacesValue != null) {
        addAllManagedSpaces(managedSpacesValue);
      }
      List<UserOrganizationResource> organizationsValue = instance.getOrganizations();
      if (organizationsValue != null) {
        addAllOrganizations(organizationsValue);
      }
      List<UserSpaceResource> spacesValue = instance.getSpaces();
      if (spacesValue != null) {
        addAllSpaces(spacesValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getAuditedOrganizations() auditedOrganizations} list.
     * @param element A auditedOrganizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganization(UserOrganizationResource element) {
      if (this.auditedOrganizations == null) {
        this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      this.auditedOrganizations.add(Objects.requireNonNull(element, "auditedOrganizations element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getAuditedOrganizations() auditedOrganizations} list.
     * @param elements An array of auditedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganization(UserOrganizationResource... elements) {
      if (this.auditedOrganizations == null) {
        this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.auditedOrganizations.add(Objects.requireNonNull(element, "auditedOrganizations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getAuditedOrganizations() auditedOrganizations} list.
     * @param elements An iterable of auditedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("audited_organizations")
    public final Builder auditedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
      if (elements == null) {
        this.auditedOrganizations = null;
        return this;
      }
      this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
      return addAllAuditedOrganizations(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getAuditedOrganizations() auditedOrganizations} list.
     * @param elements An iterable of auditedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
      Objects.requireNonNull(elements, "auditedOrganizations element");
      if (this.auditedOrganizations == null) {
        this.auditedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.auditedOrganizations.add(Objects.requireNonNull(element, "auditedOrganizations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getAuditedSpaces() auditedSpaces} list.
     * @param element A auditedSpaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpace(UserSpaceResource element) {
      if (this.auditedSpaces == null) {
        this.auditedSpaces = new ArrayList<UserSpaceResource>();
      }
      this.auditedSpaces.add(Objects.requireNonNull(element, "auditedSpaces element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getAuditedSpaces() auditedSpaces} list.
     * @param elements An array of auditedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpace(UserSpaceResource... elements) {
      if (this.auditedSpaces == null) {
        this.auditedSpaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.auditedSpaces.add(Objects.requireNonNull(element, "auditedSpaces element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getAuditedSpaces() auditedSpaces} list.
     * @param elements An iterable of auditedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("audited_spaces")
    public final Builder auditedSpaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
      if (elements == null) {
        this.auditedSpaces = null;
        return this;
      }
      this.auditedSpaces = new ArrayList<UserSpaceResource>();
      return addAllAuditedSpaces(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getAuditedSpaces() auditedSpaces} list.
     * @param elements An iterable of auditedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedSpaces(Iterable<? extends UserSpaceResource> elements) {
      Objects.requireNonNull(elements, "auditedSpaces element");
      if (this.auditedSpaces == null) {
        this.auditedSpaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.auditedSpaces.add(Objects.requireNonNull(element, "auditedSpaces element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getBillingManagedOrganizations() billingManagedOrganizations} list.
     * @param element A billingManagedOrganizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganization(UserOrganizationResource element) {
      if (this.billingManagedOrganizations == null) {
        this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      this.billingManagedOrganizations.add(Objects.requireNonNull(element, "billingManagedOrganizations element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getBillingManagedOrganizations() billingManagedOrganizations} list.
     * @param elements An array of billingManagedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganization(UserOrganizationResource... elements) {
      if (this.billingManagedOrganizations == null) {
        this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.billingManagedOrganizations.add(Objects.requireNonNull(element, "billingManagedOrganizations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getBillingManagedOrganizations() billingManagedOrganizations} list.
     * @param elements An iterable of billingManagedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("billing_managed_organizations")
    public final Builder billingManagedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
      if (elements == null) {
        this.billingManagedOrganizations = null;
        return this;
      }
      this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
      return addAllBillingManagedOrganizations(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getBillingManagedOrganizations() billingManagedOrganizations} list.
     * @param elements An iterable of billingManagedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBillingManagedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
      Objects.requireNonNull(elements, "billingManagedOrganizations element");
      if (this.billingManagedOrganizations == null) {
        this.billingManagedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.billingManagedOrganizations.add(Objects.requireNonNull(element, "billingManagedOrganizations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getManagedOrganizations() managedOrganizations} list.
     * @param element A managedOrganizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganization(UserOrganizationResource element) {
      if (this.managedOrganizations == null) {
        this.managedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      this.managedOrganizations.add(Objects.requireNonNull(element, "managedOrganizations element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getManagedOrganizations() managedOrganizations} list.
     * @param elements An array of managedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganization(UserOrganizationResource... elements) {
      if (this.managedOrganizations == null) {
        this.managedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.managedOrganizations.add(Objects.requireNonNull(element, "managedOrganizations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getManagedOrganizations() managedOrganizations} list.
     * @param elements An iterable of managedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("managed_organizations")
    public final Builder managedOrganizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
      if (elements == null) {
        this.managedOrganizations = null;
        return this;
      }
      this.managedOrganizations = new ArrayList<UserOrganizationResource>();
      return addAllManagedOrganizations(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getManagedOrganizations() managedOrganizations} list.
     * @param elements An iterable of managedOrganizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedOrganizations(Iterable<? extends UserOrganizationResource> elements) {
      Objects.requireNonNull(elements, "managedOrganizations element");
      if (this.managedOrganizations == null) {
        this.managedOrganizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.managedOrganizations.add(Objects.requireNonNull(element, "managedOrganizations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getManagedSpaces() managedSpaces} list.
     * @param element A managedSpaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpace(UserSpaceResource element) {
      if (this.managedSpaces == null) {
        this.managedSpaces = new ArrayList<UserSpaceResource>();
      }
      this.managedSpaces.add(Objects.requireNonNull(element, "managedSpaces element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getManagedSpaces() managedSpaces} list.
     * @param elements An array of managedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpace(UserSpaceResource... elements) {
      if (this.managedSpaces == null) {
        this.managedSpaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.managedSpaces.add(Objects.requireNonNull(element, "managedSpaces element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getManagedSpaces() managedSpaces} list.
     * @param elements An iterable of managedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("managed_spaces")
    public final Builder managedSpaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
      if (elements == null) {
        this.managedSpaces = null;
        return this;
      }
      this.managedSpaces = new ArrayList<UserSpaceResource>();
      return addAllManagedSpaces(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getManagedSpaces() managedSpaces} list.
     * @param elements An iterable of managedSpaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedSpaces(Iterable<? extends UserSpaceResource> elements) {
      Objects.requireNonNull(elements, "managedSpaces element");
      if (this.managedSpaces == null) {
        this.managedSpaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.managedSpaces.add(Objects.requireNonNull(element, "managedSpaces element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getOrganizations() organizations} list.
     * @param element A organizations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(UserOrganizationResource element) {
      if (this.organizations == null) {
        this.organizations = new ArrayList<UserOrganizationResource>();
      }
      this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getOrganizations() organizations} list.
     * @param elements An array of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(UserOrganizationResource... elements) {
      if (this.organizations == null) {
        this.organizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getOrganizations() organizations} list.
     * @param elements An iterable of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organizations")
    public final Builder organizations(@Nullable Iterable<? extends UserOrganizationResource> elements) {
      if (elements == null) {
        this.organizations = null;
        return this;
      }
      this.organizations = new ArrayList<UserOrganizationResource>();
      return addAllOrganizations(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getOrganizations() organizations} list.
     * @param elements An iterable of organizations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizations(Iterable<? extends UserOrganizationResource> elements) {
      Objects.requireNonNull(elements, "organizations element");
      if (this.organizations == null) {
        this.organizations = new ArrayList<UserOrganizationResource>();
      }
      for (UserOrganizationResource element : elements) {
        this.organizations.add(Objects.requireNonNull(element, "organizations element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _UserSummaryEntity#getSpaces() spaces} list.
     * @param element A spaces element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(UserSpaceResource element) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      return this;
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getSpaces() spaces} list.
     * @param elements An array of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(UserSpaceResource... elements) {
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UserSummaryEntity#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("spaces")
    public final Builder spaces(@Nullable Iterable<? extends UserSpaceResource> elements) {
      if (elements == null) {
        this.spaces = null;
        return this;
      }
      this.spaces = new ArrayList<UserSpaceResource>();
      return addAllSpaces(elements);
    }

    /**
     * Adds elements to {@link _UserSummaryEntity#getSpaces() spaces} list.
     * @param elements An iterable of spaces elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaces(Iterable<? extends UserSpaceResource> elements) {
      Objects.requireNonNull(elements, "spaces element");
      if (this.spaces == null) {
        this.spaces = new ArrayList<UserSpaceResource>();
      }
      for (UserSpaceResource element : elements) {
        this.spaces.add(Objects.requireNonNull(element, "spaces element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UserSummaryEntity UserSummaryEntity}.
     * @return An immutable instance of UserSummaryEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserSummaryEntity build() {
      return new UserSummaryEntity(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
