package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the List Organizations Relationship operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListIsolationSegmentOrganizationsRelationshipRequest"})
public final class ListIsolationSegmentOrganizationsRelationshipRequest
    extends org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentOrganizationsRelationshipRequest {
  private final String isolationSegmentId;

  private ListIsolationSegmentOrganizationsRelationshipRequest(ListIsolationSegmentOrganizationsRelationshipRequest.Builder builder) {
    this.isolationSegmentId = builder.isolationSegmentId;
  }

  /**
   * The isolation segment id
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * This instance is equal to all instances of {@code ListIsolationSegmentOrganizationsRelationshipRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIsolationSegmentOrganizationsRelationshipRequest
        && equalTo((ListIsolationSegmentOrganizationsRelationshipRequest) another);
  }

  private boolean equalTo(ListIsolationSegmentOrganizationsRelationshipRequest another) {
    return isolationSegmentId.equals(another.isolationSegmentId);
  }

  /**
   * Computes a hash code from attributes: {@code isolationSegmentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + isolationSegmentId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListIsolationSegmentOrganizationsRelationshipRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIsolationSegmentOrganizationsRelationshipRequest{"
        + "isolationSegmentId=" + isolationSegmentId
        + "}";
  }

  /**
   * Creates a builder for {@link ListIsolationSegmentOrganizationsRelationshipRequest ListIsolationSegmentOrganizationsRelationshipRequest}.
   * @return A new ListIsolationSegmentOrganizationsRelationshipRequest builder
   */
  public static ListIsolationSegmentOrganizationsRelationshipRequest.Builder builder() {
    return new ListIsolationSegmentOrganizationsRelationshipRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListIsolationSegmentOrganizationsRelationshipRequest ListIsolationSegmentOrganizationsRelationshipRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private long initBits = 0x1L;

    private String isolationSegmentId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIsolationSegmentOrganizationsRelationshipRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIsolationSegmentOrganizationsRelationshipRequest instance) {
      return from((_ListIsolationSegmentOrganizationsRelationshipRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListIsolationSegmentOrganizationsRelationshipRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIsolationSegmentOrganizationsRelationshipRequest instance) {
      Objects.requireNonNull(instance, "instance");
      isolationSegmentId(instance.getIsolationSegmentId());
      return this;
    }

    /**
     * Initializes the value for the {@link _ListIsolationSegmentOrganizationsRelationshipRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Builds a new {@link ListIsolationSegmentOrganizationsRelationshipRequest ListIsolationSegmentOrganizationsRelationshipRequest}.
     * @return An immutable instance of ListIsolationSegmentOrganizationsRelationshipRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIsolationSegmentOrganizationsRelationshipRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListIsolationSegmentOrganizationsRelationshipRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      return "Cannot build ListIsolationSegmentOrganizationsRelationshipRequest, some of required attributes are not set " + attributes;
    }
  }
}
