package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Update Process operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateProcessRequest"})
public final class UpdateProcessRequest extends org.cloudfoundry.client.v3.processes._UpdateProcessRequest {
  private final @Nullable String command;
  private final @Nullable HealthCheck healthCheck;
  private final String processId;

  private UpdateProcessRequest(UpdateProcessRequest.Builder builder) {
    this.command = builder.command;
    this.healthCheck = builder.healthCheck;
    this.processId = builder.processId;
  }

  /**
   * The command
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The health check
   */
  @Override
  public @Nullable HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateProcessRequest
        && equalTo((UpdateProcessRequest) another);
  }

  private boolean equalTo(UpdateProcessRequest another) {
    return Objects.equals(command, another.command)
        && Objects.equals(healthCheck, another.healthCheck)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code healthCheck}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(healthCheck);
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateProcessRequest{"
        + "command=" + command
        + ", healthCheck=" + healthCheck
        + ", processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateProcessRequest UpdateProcessRequest}.
   * @return A new UpdateProcessRequest builder
   */
  public static UpdateProcessRequest.Builder builder() {
    return new UpdateProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateProcessRequest UpdateProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private String command;
    private HealthCheck healthCheck;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateProcessRequest instance) {
      return from((_UpdateProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      HealthCheck healthCheckValue = instance.getHealthCheck();
      if (healthCheckValue != null) {
        healthCheck(healthCheckValue);
      }
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link UpdateProcessRequest UpdateProcessRequest}.
     * @return An immutable instance of UpdateProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build UpdateProcessRequest, some of required attributes are not set " + attributes;
    }
  }
}
