package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The data for a {@link ServiceBinding}
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceBindingData"})
public final class ServiceBindingData extends org.cloudfoundry.client.v3.servicebindings._ServiceBindingData {
  private final @Nullable Map<String, Object> credentials;
  private final @Nullable String syslogDrainUrl;
  private final @Nullable List<String> volumeMounts;

  private ServiceBindingData(ServiceBindingData.Builder builder) {
    this.credentials = builder.credentials == null ? null : createUnmodifiableMap(false, false, builder.credentials);
    this.syslogDrainUrl = builder.syslogDrainUrl;
    this.volumeMounts = builder.volumeMounts == null ? null : createUnmodifiableList(true, builder.volumeMounts);
  }

  /**
   * The service binding credentials
   */
  @JsonProperty("credentials")
  @Override
  public @Nullable Map<String, Object> getCredentials() {
    return credentials;
  }

  /**
   * The syslog drain URL
   */
  @JsonProperty("syslog_drain_url")
  @Override
  public @Nullable String getSyslogDrainUrl() {
    return syslogDrainUrl;
  }

  /**
   * The (experimental) volume mounts
   */
  @JsonProperty("volume_mounts")
  @Override
  public @Nullable List<String> getVolumeMounts() {
    return volumeMounts;
  }

  /**
   * This instance is equal to all instances of {@code ServiceBindingData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceBindingData
        && equalTo((ServiceBindingData) another);
  }

  private boolean equalTo(ServiceBindingData another) {
    return Objects.equals(credentials, another.credentials)
        && Objects.equals(syslogDrainUrl, another.syslogDrainUrl)
        && Objects.equals(volumeMounts, another.volumeMounts);
  }

  /**
   * Computes a hash code from attributes: {@code credentials}, {@code syslogDrainUrl}, {@code volumeMounts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(credentials);
    h += (h << 5) + Objects.hashCode(syslogDrainUrl);
    h += (h << 5) + Objects.hashCode(volumeMounts);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceBindingData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceBindingData{"
        + "credentials=" + credentials
        + ", syslogDrainUrl=" + syslogDrainUrl
        + ", volumeMounts=" + volumeMounts
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._ServiceBindingData {
    Map<String, Object> credentials = null;
    String syslogDrainUrl;
    List<String> volumeMounts = null;
    @JsonProperty("credentials")
    public void setCredentials(@Nullable Map<String, Object> credentials) {
      this.credentials = credentials;
    }
    @JsonProperty("syslog_drain_url")
    public void setSyslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
    }
    @JsonProperty("volume_mounts")
    public void setVolumeMounts(@Nullable List<String> volumeMounts) {
      this.volumeMounts = volumeMounts;
    }
    @Override
    public Map<String, Object> getCredentials() { throw new UnsupportedOperationException(); }
    @Override
    public String getSyslogDrainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getVolumeMounts() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceBindingData fromJson(Json json) {
    ServiceBindingData.Builder builder = ServiceBindingData.builder();
    if (json.credentials != null) {
      builder.putAllCredentials(json.credentials);
    }
    if (json.syslogDrainUrl != null) {
      builder.syslogDrainUrl(json.syslogDrainUrl);
    }
    if (json.volumeMounts != null) {
      builder.addAllVolumeMounts(json.volumeMounts);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceBindingData ServiceBindingData}.
   * @return A new ServiceBindingData builder
   */
  public static ServiceBindingData.Builder builder() {
    return new ServiceBindingData.Builder();
  }

  /**
   * Builds instances of type {@link ServiceBindingData ServiceBindingData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Map<String, Object> credentials = null;
    private String syslogDrainUrl;
    private List<String> volumeMounts = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceBindingData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBindingData instance) {
      return from((_ServiceBindingData) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceBindingData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceBindingData instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> credentialsValue = instance.getCredentials();
      if (credentialsValue != null) {
        putAllCredentials(credentialsValue);
      }
      String syslogDrainUrlValue = instance.getSyslogDrainUrl();
      if (syslogDrainUrlValue != null) {
        syslogDrainUrl(syslogDrainUrlValue);
      }
      List<String> volumeMountsValue = instance.getVolumeMounts();
      if (volumeMountsValue != null) {
        addAllVolumeMounts(volumeMountsValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingData#getCredentials() credentials} map.
     * @param key The key in the credentials map
     * @param value The associated value in the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(String key, Object value) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      this.credentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ServiceBindingData#getCredentials() credentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder credential(Map.Entry<String, ? extends Object> entry) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.credentials.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ServiceBindingData#getCredentials() credentials} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("credentials")
    public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
      if (credentials == null) {
        this.credentials = null;
        return this;
      }
      this.credentials = new LinkedHashMap<String, Object>();
      return putAllCredentials(credentials);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ServiceBindingData#getCredentials() credentials} map. Nulls are not permitted
     * @param credentials The entries that will be added to the credentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
      if (this.credentials == null) {
        this.credentials = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.credentials.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceBindingData#getSyslogDrainUrl() syslogDrainUrl} attribute.
     * @param syslogDrainUrl The value for syslogDrainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("syslog_drain_url")
    public final Builder syslogDrainUrl(@Nullable String syslogDrainUrl) {
      this.syslogDrainUrl = syslogDrainUrl;
      return this;
    }

    /**
     * Adds one element to {@link _ServiceBindingData#getVolumeMounts() volumeMounts} list.
     * @param element A volumeMounts element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumeMount(String element) {
      if (this.volumeMounts == null) {
        this.volumeMounts = new ArrayList<String>();
      }
      this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      return this;
    }

    /**
     * Adds elements to {@link _ServiceBindingData#getVolumeMounts() volumeMounts} list.
     * @param elements An array of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder volumeMount(String... elements) {
      if (this.volumeMounts == null) {
        this.volumeMounts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ServiceBindingData#getVolumeMounts() volumeMounts} list.
     * @param elements An iterable of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("volume_mounts")
    public final Builder volumeMounts(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.volumeMounts = null;
        return this;
      }
      this.volumeMounts = new ArrayList<String>();
      return addAllVolumeMounts(elements);
    }

    /**
     * Adds elements to {@link _ServiceBindingData#getVolumeMounts() volumeMounts} list.
     * @param elements An iterable of volumeMounts elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVolumeMounts(Iterable<String> elements) {
      Objects.requireNonNull(elements, "volumeMounts element");
      if (this.volumeMounts == null) {
        this.volumeMounts = new ArrayList<String>();
      }
      for (String element : elements) {
        this.volumeMounts.add(Objects.requireNonNull(element, "volumeMounts element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ServiceBindingData ServiceBindingData}.
     * @return An immutable instance of ServiceBindingData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceBindingData build() {
      return new ServiceBindingData(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
