package org.cloudfoundry.routing.v1.routergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response payload for the List Router Groups operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListRouterGroupsResponse"})
public final class ListRouterGroupsResponse
    extends org.cloudfoundry.routing.v1.routergroups._ListRouterGroupsResponse {
  private final List<RouterGroup> routerGroups;

  private ListRouterGroupsResponse(ListRouterGroupsResponse.Builder builder) {
    this.routerGroups = createUnmodifiableList(true, builder.routerGroups);
  }

  /**
   * The Router Groups
   */
  @JsonProperty("routerGroups")
  @Override
  public List<RouterGroup> getRouterGroups() {
    return routerGroups;
  }

  /**
   * This instance is equal to all instances of {@code ListRouterGroupsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRouterGroupsResponse
        && equalTo((ListRouterGroupsResponse) another);
  }

  private boolean equalTo(ListRouterGroupsResponse another) {
    return routerGroups.equals(another.routerGroups);
  }

  /**
   * Computes a hash code from attributes: {@code routerGroups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + routerGroups.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListRouterGroupsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRouterGroupsResponse{"
        + "routerGroups=" + routerGroups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.routing.v1.routergroups._ListRouterGroupsResponse {
    List<RouterGroup> routerGroups = Collections.emptyList();
    @JsonProperty("routerGroups")
    public void setRouterGroups(List<RouterGroup> routerGroups) {
      this.routerGroups = routerGroups;
    }
    @Override
    public List<RouterGroup> getRouterGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListRouterGroupsResponse fromJson(Json json) {
    ListRouterGroupsResponse.Builder builder = ListRouterGroupsResponse.builder();
    if (json.routerGroups != null) {
      builder.addAllRouterGroups(json.routerGroups);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListRouterGroupsResponse ListRouterGroupsResponse}.
   * @return A new ListRouterGroupsResponse builder
   */
  public static ListRouterGroupsResponse.Builder builder() {
    return new ListRouterGroupsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListRouterGroupsResponse ListRouterGroupsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<RouterGroup> routerGroups = new ArrayList<RouterGroup>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRouterGroupsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRouterGroupsResponse instance) {
      return from((_ListRouterGroupsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListRouterGroupsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListRouterGroupsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllRouterGroups(instance.getRouterGroups());
      return this;
    }

    /**
     * Adds one element to {@link _ListRouterGroupsResponse#getRouterGroups() routerGroups} list.
     * @param element A routerGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroup(RouterGroup element) {
      this.routerGroups.add(Objects.requireNonNull(element, "routerGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListRouterGroupsResponse#getRouterGroups() routerGroups} list.
     * @param elements An array of routerGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routerGroup(RouterGroup... elements) {
      for (RouterGroup element : elements) {
        this.routerGroups.add(Objects.requireNonNull(element, "routerGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListRouterGroupsResponse#getRouterGroups() routerGroups} list.
     * @param elements An iterable of routerGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("routerGroups")
    public final Builder routerGroups(Iterable<? extends RouterGroup> elements) {
      this.routerGroups.clear();
      return addAllRouterGroups(elements);
    }

    /**
     * Adds elements to {@link _ListRouterGroupsResponse#getRouterGroups() routerGroups} list.
     * @param elements An iterable of routerGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRouterGroups(Iterable<? extends RouterGroup> elements) {
      for (RouterGroup element : elements) {
        this.routerGroups.add(Objects.requireNonNull(element, "routerGroups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListRouterGroupsResponse ListRouterGroupsResponse}.
     * @return An immutable instance of ListRouterGroupsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRouterGroupsResponse build() {
      return new ListRouterGroupsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
