package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the expire password operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ExpirePasswordRequest"})
public final class ExpirePasswordRequest extends org.cloudfoundry.uaa.users._ExpirePasswordRequest {
  private final Boolean passwordChangeRequired;
  private final String userId;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private ExpirePasswordRequest(ExpirePasswordRequest.Builder builder) {
    this.passwordChangeRequired = builder.passwordChangeRequired;
    this.userId = builder.userId;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * Whether to expire the user's password
   */
  @Override
  public Boolean getPasswordChangeRequired() {
    return passwordChangeRequired;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code ExpirePasswordRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ExpirePasswordRequest
        && equalTo((ExpirePasswordRequest) another);
  }

  private boolean equalTo(ExpirePasswordRequest another) {
    return passwordChangeRequired.equals(another.passwordChangeRequired)
        && userId.equals(another.userId)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code passwordChangeRequired}, {@code userId}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + passwordChangeRequired.hashCode();
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code ExpirePasswordRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExpirePasswordRequest{"
        + "passwordChangeRequired=" + passwordChangeRequired
        + ", userId=" + userId
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link ExpirePasswordRequest ExpirePasswordRequest}.
   * @return A new ExpirePasswordRequest builder
   */
  public static ExpirePasswordRequest.Builder builder() {
    return new ExpirePasswordRequest.Builder();
  }

  /**
   * Builds instances of type {@link ExpirePasswordRequest ExpirePasswordRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PASSWORD_CHANGE_REQUIRED = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private Boolean passwordChangeRequired;
    private String userId;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExpirePasswordRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExpirePasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ExpirePasswordRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ExpirePasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._ExpirePasswordRequest) {
        org.cloudfoundry.uaa.users._ExpirePasswordRequest instance = (org.cloudfoundry.uaa.users._ExpirePasswordRequest) object;
        userId(instance.getUserId());
        passwordChangeRequired(instance.getPasswordChangeRequired());
      }
    }

    /**
     * Initializes the value for the {@link _ExpirePasswordRequest#getPasswordChangeRequired() passwordChangeRequired} attribute.
     * @param passwordChangeRequired The value for passwordChangeRequired 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder passwordChangeRequired(Boolean passwordChangeRequired) {
      this.passwordChangeRequired = Objects.requireNonNull(passwordChangeRequired, "passwordChangeRequired");
      initBits &= ~INIT_BIT_PASSWORD_CHANGE_REQUIRED;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExpirePasswordRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExpirePasswordRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ExpirePasswordRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link ExpirePasswordRequest ExpirePasswordRequest}.
     * @return An immutable instance of ExpirePasswordRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ExpirePasswordRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ExpirePasswordRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PASSWORD_CHANGE_REQUIRED) != 0) attributes.add("passwordChangeRequired");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ExpirePasswordRequest, some of required attributes are not set " + attributes;
    }
  }
}
