/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.applications._CopyApplicationRequest;

public final class CopyApplicationRequest
extends _CopyApplicationRequest {
    private final String applicationId;
    private final String sourceApplicationId;

    private CopyApplicationRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.sourceApplicationId = builder.sourceApplicationId;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getSourceApplicationId() {
        return this.sourceApplicationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CopyApplicationRequest && this.equalTo((CopyApplicationRequest)another);
    }

    private boolean equalTo(CopyApplicationRequest another) {
        return this.applicationId.equals(another.applicationId) && this.sourceApplicationId.equals(another.sourceApplicationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.sourceApplicationId.hashCode();
        return h;
    }

    public String toString() {
        return "CopyApplicationRequest{applicationId=" + this.applicationId + ", sourceApplicationId=" + this.sourceApplicationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private static final long INIT_BIT_SOURCE_APPLICATION_ID = 2L;
        private long initBits = 3L;
        private String applicationId;
        private String sourceApplicationId;

        private Builder() {
        }

        public final Builder from(CopyApplicationRequest instance) {
            return this.from((_CopyApplicationRequest)instance);
        }

        final Builder from(_CopyApplicationRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.applicationId(instance.getApplicationId());
            this.sourceApplicationId(instance.getSourceApplicationId());
            return this;
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourceApplicationId(String sourceApplicationId) {
            this.sourceApplicationId = Objects.requireNonNull(sourceApplicationId, "sourceApplicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CopyApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CopyApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceApplicationId");
            }
            return "Cannot build CopyApplicationRequest, some of required attributes are not set " + attributes;
        }
    }
}

