/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.organizations._AssociateOrganizationManagerRequest;

public final class AssociateOrganizationManagerRequest
extends _AssociateOrganizationManagerRequest {
    private final String managerId;
    private final String organizationId;

    private AssociateOrganizationManagerRequest(Builder builder) {
        this.managerId = builder.managerId;
        this.organizationId = builder.organizationId;
    }

    @Override
    public String getManagerId() {
        return this.managerId;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AssociateOrganizationManagerRequest && this.equalTo((AssociateOrganizationManagerRequest)another);
    }

    private boolean equalTo(AssociateOrganizationManagerRequest another) {
        return this.managerId.equals(another.managerId) && this.organizationId.equals(another.organizationId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.managerId.hashCode();
        h += (h << 5) + this.organizationId.hashCode();
        return h;
    }

    public String toString() {
        return "AssociateOrganizationManagerRequest{managerId=" + this.managerId + ", organizationId=" + this.organizationId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MANAGER_ID = 1L;
        private static final long INIT_BIT_ORGANIZATION_ID = 2L;
        private long initBits = 3L;
        private String managerId;
        private String organizationId;

        private Builder() {
        }

        public final Builder from(AssociateOrganizationManagerRequest instance) {
            return this.from((_AssociateOrganizationManagerRequest)instance);
        }

        final Builder from(_AssociateOrganizationManagerRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.managerId(instance.getManagerId());
            this.organizationId(instance.getOrganizationId());
            return this;
        }

        public final Builder managerId(String managerId) {
            this.managerId = Objects.requireNonNull(managerId, "managerId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AssociateOrganizationManagerRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AssociateOrganizationManagerRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("managerId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build AssociateOrganizationManagerRequest, some of required attributes are not set " + attributes;
        }
    }
}

