/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.organizations._UpdateOrganizationRequest;

public final class UpdateOrganizationRequest
extends _UpdateOrganizationRequest {
    @Nullable
    private final String name;
    private final String organizationId;
    @Nullable
    private final String quotaDefinitionId;
    @Nullable
    private final String status;

    private UpdateOrganizationRequest(Builder builder) {
        this.name = builder.name;
        this.organizationId = builder.organizationId;
        this.quotaDefinitionId = builder.quotaDefinitionId;
        this.status = builder.status;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @Override
    @Nullable
    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateOrganizationRequest && this.equalTo((UpdateOrganizationRequest)another);
    }

    private boolean equalTo(UpdateOrganizationRequest another) {
        return Objects.equals(this.name, another.name) && this.organizationId.equals(another.organizationId) && Objects.equals(this.quotaDefinitionId, another.quotaDefinitionId) && Objects.equals(this.status, another.status);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + Objects.hashCode(this.quotaDefinitionId);
        h += (h << 5) + Objects.hashCode(this.status);
        return h;
    }

    public String toString() {
        return "UpdateOrganizationRequest{name=" + this.name + ", organizationId=" + this.organizationId + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private long initBits = 1L;
        private String name;
        private String organizationId;
        private String quotaDefinitionId;
        private String status;

        private Builder() {
        }

        public final Builder from(UpdateOrganizationRequest instance) {
            return this.from((_UpdateOrganizationRequest)instance);
        }

        final Builder from(_UpdateOrganizationRequest instance) {
            String statusValue;
            Objects.requireNonNull(instance, "instance");
            String nameValue = instance.getName();
            if (nameValue != null) {
                this.name(nameValue);
            }
            this.organizationId(instance.getOrganizationId());
            String quotaDefinitionIdValue = instance.getQuotaDefinitionId();
            if (quotaDefinitionIdValue != null) {
                this.quotaDefinitionId(quotaDefinitionIdValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder quotaDefinitionId(@Nullable String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public final Builder status(@Nullable String status) {
            this.status = status;
            return this;
        }

        public UpdateOrganizationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateOrganizationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            return "Cannot build UpdateOrganizationRequest, some of required attributes are not set " + attributes;
        }
    }
}

