/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.servicekeys;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.servicekeys._ServiceKeyEntity;

public final class ServiceKeyEntity
extends _ServiceKeyEntity {
    @Nullable
    private final Map<String, Object> credentials;
    @Nullable
    private final String name;
    @Nullable
    private final String serviceInstanceId;
    @Nullable
    private final String serviceInstanceUrl;

    private ServiceKeyEntity(Builder builder) {
        this.credentials = builder.credentials == null ? null : ServiceKeyEntity.createUnmodifiableMap(false, false, builder.credentials);
        this.name = builder.name;
        this.serviceInstanceId = builder.serviceInstanceId;
        this.serviceInstanceUrl = builder.serviceInstanceUrl;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="service_instance_guid")
    @Nullable
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="service_instance_url")
    @Nullable
    public String getServiceInstanceUrl() {
        return this.serviceInstanceUrl;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ServiceKeyEntity && this.equalTo((ServiceKeyEntity)another);
    }

    private boolean equalTo(ServiceKeyEntity another) {
        return Objects.equals(this.credentials, another.credentials) && Objects.equals(this.name, another.name) && Objects.equals(this.serviceInstanceId, another.serviceInstanceId) && Objects.equals(this.serviceInstanceUrl, another.serviceInstanceUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceId);
        h += (h << 5) + Objects.hashCode(this.serviceInstanceUrl);
        return h;
    }

    public String toString() {
        return "ServiceKeyEntity{credentials=" + this.credentials + ", name=" + this.name + ", serviceInstanceId=" + this.serviceInstanceId + ", serviceInstanceUrl=" + this.serviceInstanceUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ServiceKeyEntity fromJson(Json json) {
        Builder builder = ServiceKeyEntity.builder();
        if (json.credentials != null) {
            builder.putAllCredentials(json.credentials);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        if (json.serviceInstanceUrl != null) {
            builder.serviceInstanceUrl(json.serviceInstanceUrl);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, Object> credentials = null;
        private String name;
        private String serviceInstanceId;
        private String serviceInstanceUrl;

        private Builder() {
        }

        public final Builder from(ServiceKeyEntity instance) {
            return this.from((_ServiceKeyEntity)instance);
        }

        final Builder from(_ServiceKeyEntity instance) {
            String serviceInstanceUrlValue;
            String serviceInstanceIdValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> credentialsValue = instance.getCredentials();
            if (credentialsValue != null) {
                this.putAllCredentials(credentialsValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((serviceInstanceIdValue = instance.getServiceInstanceId()) != null) {
                this.serviceInstanceId(serviceInstanceIdValue);
            }
            if ((serviceInstanceUrlValue = instance.getServiceInstanceUrl()) != null) {
                this.serviceInstanceUrl(serviceInstanceUrlValue);
            }
            return this;
        }

        public final Builder credential(String key, Object value) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            this.credentials.put(key, value);
            return this;
        }

        public final Builder credential(Map.Entry<String, ? extends Object> entry) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.credentials.put(k, v);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(@Nullable Map<String, ? extends Object> credentials) {
            if (credentials == null) {
                this.credentials = null;
                return this;
            }
            this.credentials = new LinkedHashMap<String, Object>();
            return this.putAllCredentials(credentials);
        }

        public final Builder putAllCredentials(Map<String, ? extends Object> credentials) {
            if (this.credentials == null) {
                this.credentials = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> entry : credentials.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.credentials.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="service_instance_guid")
        public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        @JsonProperty(value="service_instance_url")
        public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
            return this;
        }

        public ServiceKeyEntity build() {
            return new ServiceKeyEntity(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ServiceKeyEntity {
        Map<String, Object> credentials = null;
        String name;
        String serviceInstanceId;
        String serviceInstanceUrl;

        Json() {
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Map<String, Object> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="service_instance_guid")
        public void setServiceInstanceId(@Nullable String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @JsonProperty(value="service_instance_url")
        public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
            this.serviceInstanceUrl = serviceInstanceUrl;
        }

        @Override
        public Map<String, Object> getCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

