/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceplanvisibilities;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.serviceplanvisibilities._UpdateServicePlanVisibilityRequest;

public final class UpdateServicePlanVisibilityRequest
extends _UpdateServicePlanVisibilityRequest {
    private final String organizationId;
    private final String servicePlanId;
    private final String servicePlanVisibilityId;

    private UpdateServicePlanVisibilityRequest(Builder builder) {
        this.organizationId = builder.organizationId;
        this.servicePlanId = builder.servicePlanId;
        this.servicePlanVisibilityId = builder.servicePlanVisibilityId;
    }

    @Override
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    public String getServicePlanId() {
        return this.servicePlanId;
    }

    @Override
    public String getServicePlanVisibilityId() {
        return this.servicePlanVisibilityId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateServicePlanVisibilityRequest && this.equalTo((UpdateServicePlanVisibilityRequest)another);
    }

    private boolean equalTo(UpdateServicePlanVisibilityRequest another) {
        return this.organizationId.equals(another.organizationId) && this.servicePlanId.equals(another.servicePlanId) && this.servicePlanVisibilityId.equals(another.servicePlanVisibilityId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.organizationId.hashCode();
        h += (h << 5) + this.servicePlanId.hashCode();
        h += (h << 5) + this.servicePlanVisibilityId.hashCode();
        return h;
    }

    public String toString() {
        return "UpdateServicePlanVisibilityRequest{organizationId=" + this.organizationId + ", servicePlanId=" + this.servicePlanId + ", servicePlanVisibilityId=" + this.servicePlanVisibilityId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORGANIZATION_ID = 1L;
        private static final long INIT_BIT_SERVICE_PLAN_ID = 2L;
        private static final long INIT_BIT_SERVICE_PLAN_VISIBILITY_ID = 4L;
        private long initBits = 7L;
        private String organizationId;
        private String servicePlanId;
        private String servicePlanVisibilityId;

        private Builder() {
        }

        public final Builder from(UpdateServicePlanVisibilityRequest instance) {
            return this.from((_UpdateServicePlanVisibilityRequest)instance);
        }

        final Builder from(_UpdateServicePlanVisibilityRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.organizationId(instance.getOrganizationId());
            this.servicePlanId(instance.getServicePlanId());
            this.servicePlanVisibilityId(instance.getServicePlanVisibilityId());
            return this;
        }

        public final Builder organizationId(String organizationId) {
            this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = Objects.requireNonNull(servicePlanId, "servicePlanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder servicePlanVisibilityId(String servicePlanVisibilityId) {
            this.servicePlanVisibilityId = Objects.requireNonNull(servicePlanVisibilityId, "servicePlanVisibilityId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public UpdateServicePlanVisibilityRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new UpdateServicePlanVisibilityRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("organizationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("servicePlanId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("servicePlanVisibilityId");
            }
            return "Cannot build UpdateServicePlanVisibilityRequest, some of required attributes are not set " + attributes;
        }
    }
}

