/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.spaces._RemoveSpaceManagerByUsernameRequest;

public final class RemoveSpaceManagerByUsernameRequest
extends _RemoveSpaceManagerByUsernameRequest {
    private final String spaceId;
    private final String username;

    private RemoveSpaceManagerByUsernameRequest(Builder builder) {
        this.spaceId = builder.spaceId;
        this.username = builder.username;
    }

    @Override
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RemoveSpaceManagerByUsernameRequest && this.equalTo((RemoveSpaceManagerByUsernameRequest)another);
    }

    private boolean equalTo(RemoveSpaceManagerByUsernameRequest another) {
        return this.spaceId.equals(another.spaceId) && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.spaceId.hashCode();
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "RemoveSpaceManagerByUsernameRequest{spaceId=" + this.spaceId + ", username=" + this.username + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_SPACE_ID = 1L;
        private static final long INIT_BIT_USERNAME = 2L;
        private long initBits = 3L;
        private String spaceId;
        private String username;

        private Builder() {
        }

        public final Builder from(RemoveSpaceManagerByUsernameRequest instance) {
            return this.from((_RemoveSpaceManagerByUsernameRequest)instance);
        }

        final Builder from(_RemoveSpaceManagerByUsernameRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.spaceId(instance.getSpaceId());
            this.username(instance.getUsername());
            return this;
        }

        public final Builder spaceId(String spaceId) {
            this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public RemoveSpaceManagerByUsernameRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RemoveSpaceManagerByUsernameRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("spaceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build RemoveSpaceManagerByUsernameRequest, some of required attributes are not set " + attributes;
        }
    }
}

