/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v2.users._GetUserRequest;

public final class GetUserRequest
extends _GetUserRequest {
    private final String userId;

    private GetUserRequest(Builder builder) {
        this.userId = builder.userId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetUserRequest && this.equalTo((GetUserRequest)another);
    }

    private boolean equalTo(GetUserRequest another) {
        return this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "GetUserRequest{userId=" + this.userId + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private long initBits = 1L;
        private String userId;

        private Builder() {
        }

        public final Builder from(GetUserRequest instance) {
            return this.from((_GetUserRequest)instance);
        }

        final Builder from(_GetUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.getUserId());
            return this;
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public GetUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GetUserRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build GetUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

