/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.applications._ListApplicationPackagesRequest;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.cloudfoundry.client.v3.packages.PackageType;

public final class ListApplicationPackagesRequest
extends _ListApplicationPackagesRequest {
    private final String applicationId;
    private final List<String> packageIds;
    private final List<PackageState> states;
    private final List<PackageType> types;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListApplicationPackagesRequest(Builder builder) {
        this.applicationId = builder.applicationId;
        this.packageIds = ListApplicationPackagesRequest.createUnmodifiableList(true, builder.packageIds);
        this.states = ListApplicationPackagesRequest.createUnmodifiableList(true, builder.states);
        this.types = ListApplicationPackagesRequest.createUnmodifiableList(true, builder.types);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public List<String> getPackageIds() {
        return this.packageIds;
    }

    @Override
    public List<PackageState> getStates() {
        return this.states;
    }

    @Override
    public List<PackageType> getTypes() {
        return this.types;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListApplicationPackagesRequest && this.equalTo((ListApplicationPackagesRequest)another);
    }

    private boolean equalTo(ListApplicationPackagesRequest another) {
        return this.applicationId.equals(another.applicationId) && this.packageIds.equals(another.packageIds) && this.states.equals(another.states) && this.types.equals(another.types) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationId.hashCode();
        h += (h << 5) + this.packageIds.hashCode();
        h += (h << 5) + this.states.hashCode();
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListApplicationPackagesRequest{applicationId=" + this.applicationId + ", packageIds=" + this.packageIds + ", states=" + this.states + ", types=" + this.types + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_APPLICATION_ID = 1L;
        private long initBits = 1L;
        private String applicationId;
        private List<String> packageIds = new ArrayList<String>();
        private List<PackageState> states = new ArrayList<PackageState>();
        private List<PackageType> types = new ArrayList<PackageType>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(ListApplicationPackagesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ListApplicationPackagesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListApplicationPackagesRequest) {
                instance = (_ListApplicationPackagesRequest)object;
                this.addAllTypes(((_ListApplicationPackagesRequest)instance).getTypes());
                this.applicationId(((_ListApplicationPackagesRequest)instance).getApplicationId());
                this.addAllPackageIds(((_ListApplicationPackagesRequest)instance).getPackageIds());
                this.addAllStates(((_ListApplicationPackagesRequest)instance).getStates());
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder applicationId(String applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder packageId(String element) {
            this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            return this;
        }

        public final Builder packageId(String ... elements) {
            for (String element : elements) {
                this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            }
            return this;
        }

        public final Builder packageIds(Iterable<String> elements) {
            this.packageIds.clear();
            return this.addAllPackageIds(elements);
        }

        public final Builder addAllPackageIds(Iterable<String> elements) {
            for (String element : elements) {
                this.packageIds.add(Objects.requireNonNull(element, "packageIds element"));
            }
            return this;
        }

        public final Builder state(PackageState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder state(PackageState ... elements) {
            for (PackageState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends PackageState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends PackageState> elements) {
            for (PackageState packageState : elements) {
                this.states.add(Objects.requireNonNull(packageState, "states element"));
            }
            return this;
        }

        public final Builder type(PackageType element) {
            this.types.add(Objects.requireNonNull(element, "types element"));
            return this;
        }

        public final Builder type(PackageType ... elements) {
            for (PackageType element : elements) {
                this.types.add(Objects.requireNonNull(element, "types element"));
            }
            return this;
        }

        public final Builder types(Iterable<? extends PackageType> elements) {
            this.types.clear();
            return this.addAllTypes(elements);
        }

        public final Builder addAllTypes(Iterable<? extends PackageType> elements) {
            for (PackageType packageType : elements) {
                this.types.add(Objects.requireNonNull(packageType, "types element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationPackagesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListApplicationPackagesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("applicationId");
            }
            return "Cannot build ListApplicationPackagesRequest, some of required attributes are not set " + attributes;
        }
    }
}

