/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.spaces;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.client.v3.spaces.SpaceRelationships;
import org.cloudfoundry.client.v3.spaces._CreateSpaceRequest;

public final class CreateSpaceRequest
extends _CreateSpaceRequest {
    private final String name;
    private final SpaceRelationships relationships;

    private CreateSpaceRequest(Builder builder) {
        this.name = builder.name;
        this.relationships = builder.relationships;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SpaceRelationships getRelationships() {
        return this.relationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateSpaceRequest && this.equalTo((CreateSpaceRequest)another);
    }

    private boolean equalTo(CreateSpaceRequest another) {
        return this.name.equals(another.name) && this.relationships.equals(another.relationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        return h;
    }

    public String toString() {
        return "CreateSpaceRequest{name=" + this.name + ", relationships=" + this.relationships + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RELATIONSHIPS = 2L;
        private long initBits = 3L;
        private String name;
        private SpaceRelationships relationships;

        private Builder() {
        }

        public final Builder from(CreateSpaceRequest instance) {
            return this.from((_CreateSpaceRequest)instance);
        }

        final Builder from(_CreateSpaceRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.relationships(instance.getRelationships());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationships(SpaceRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateSpaceRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateSpaceRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationships");
            }
            return "Cannot build CreateSpaceRequest, some of required attributes are not set " + attributes;
        }
    }
}

