/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.MessageType;
import org.cloudfoundry.doppler._LogMessage;

public final class LogMessage
extends _LogMessage {
    @Nullable
    private final String applicationId;
    private final String message;
    private final MessageType messageType;
    @Nullable
    private final String sourceInstance;
    @Nullable
    private final String sourceType;
    private final Long timestamp;

    private LogMessage(Builder builder) {
        this.applicationId = builder.applicationId;
        this.message = builder.message;
        this.messageType = builder.messageType;
        this.sourceInstance = builder.sourceInstance;
        this.sourceType = builder.sourceType;
        this.timestamp = builder.timestamp;
    }

    @Override
    @Nullable
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Override
    @Nullable
    public String getSourceInstance() {
        return this.sourceInstance;
    }

    @Override
    @Nullable
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LogMessage && this.equalTo((LogMessage)another);
    }

    private boolean equalTo(LogMessage another) {
        return Objects.equals(this.applicationId, another.applicationId) && this.message.equals(another.message) && this.messageType.equals((Object)another.messageType) && Objects.equals(this.sourceInstance, another.sourceInstance) && Objects.equals(this.sourceType, another.sourceType) && this.timestamp.equals(another.timestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationId);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.messageType.hashCode();
        h += (h << 5) + Objects.hashCode(this.sourceInstance);
        h += (h << 5) + Objects.hashCode(this.sourceType);
        h += (h << 5) + this.timestamp.hashCode();
        return h;
    }

    public String toString() {
        return "LogMessage{applicationId=" + this.applicationId + ", message=" + this.message + ", messageType=" + (Object)((Object)this.messageType) + ", sourceInstance=" + this.sourceInstance + ", sourceType=" + this.sourceType + ", timestamp=" + this.timestamp + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_MESSAGE_TYPE = 2L;
        private static final long INIT_BIT_TIMESTAMP = 4L;
        private long initBits = 7L;
        private String applicationId;
        private String message;
        private MessageType messageType;
        private String sourceInstance;
        private String sourceType;
        private Long timestamp;

        private Builder() {
        }

        public final Builder from(LogMessage instance) {
            return this.from((_LogMessage)instance);
        }

        final Builder from(_LogMessage instance) {
            String sourceTypeValue;
            Objects.requireNonNull(instance, "instance");
            String applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            this.message(instance.getMessage());
            this.messageType(instance.getMessageType());
            String sourceInstanceValue = instance.getSourceInstance();
            if (sourceInstanceValue != null) {
                this.sourceInstance(sourceInstanceValue);
            }
            if ((sourceTypeValue = instance.getSourceType()) != null) {
                this.sourceType(sourceTypeValue);
            }
            this.timestamp(instance.getTimestamp());
            return this;
        }

        public final Builder applicationId(@Nullable String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder messageType(MessageType messageType) {
            this.messageType = Objects.requireNonNull(messageType, "messageType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder sourceInstance(@Nullable String sourceInstance) {
            this.sourceInstance = sourceInstance;
            return this;
        }

        public final Builder sourceType(@Nullable String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final Builder timestamp(Long timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public LogMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new LogMessage(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("messageType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("timestamp");
            }
            return "Cannot build LogMessage, some of required attributes are not set " + attributes;
        }
    }
}

