/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.clients.AbstractChangeSecret;
import org.cloudfoundry.uaa.clients._ChangeSecretRequest;

public final class ChangeSecretRequest
extends _ChangeSecretRequest {
    private final String clientId;
    @Nullable
    private final String oldSecret;
    private final String secret;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private ChangeSecretRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.oldSecret = builder.oldSecret;
        this.secret = builder.secret;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getOldSecret() {
        return this.oldSecret;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChangeSecretRequest && this.equalTo((ChangeSecretRequest)another);
    }

    private boolean equalTo(ChangeSecretRequest another) {
        return this.clientId.equals(another.clientId) && Objects.equals(this.oldSecret, another.oldSecret) && this.secret.equals(another.secret) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.oldSecret);
        h += (h << 5) + this.secret.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "ChangeSecretRequest{clientId=" + this.clientId + ", oldSecret=" + this.oldSecret + ", secret=" + this.secret + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_SECRET = 2L;
        private long initBits = 3L;
        private String clientId;
        private String oldSecret;
        private String secret;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractChangeSecret instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChangeSecretRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_ChangeSecretRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof AbstractChangeSecret) {
                instance = (AbstractChangeSecret)object;
                String oldSecretValue = ((AbstractChangeSecret)instance).getOldSecret();
                if (oldSecretValue != null) {
                    this.oldSecret(oldSecretValue);
                }
                this.clientId(((AbstractChangeSecret)instance).getClientId());
                this.secret(((AbstractChangeSecret)instance).getSecret());
            }
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder oldSecret(@Nullable String oldSecret) {
            this.oldSecret = oldSecret;
            return this;
        }

        public final Builder secret(String secret) {
            this.secret = Objects.requireNonNull(secret, "secret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public ChangeSecretRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ChangeSecretRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("secret");
            }
            return "Cannot build ChangeSecretRequest, some of required attributes are not set " + attributes;
        }
    }
}

