/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.clients.Metadata;
import org.cloudfoundry.uaa.clients._ListMetadatasResponse;

public final class ListMetadatasResponse
extends _ListMetadatasResponse {
    private final List<Metadata> metadatas;

    private ListMetadatasResponse(Builder builder) {
        this.metadatas = ListMetadatasResponse.createUnmodifiableList(true, builder.metadatas);
    }

    @Override
    @JsonProperty(value="metadatas")
    public List<Metadata> getMetadatas() {
        return this.metadatas;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListMetadatasResponse && this.equalTo((ListMetadatasResponse)another);
    }

    private boolean equalTo(ListMetadatasResponse another) {
        return this.metadatas.equals(another.metadatas);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metadatas.hashCode();
        return h;
    }

    public String toString() {
        return "ListMetadatasResponse{metadatas=" + this.metadatas + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListMetadatasResponse fromJson(Json json) {
        Builder builder = ListMetadatasResponse.builder();
        if (json.metadatas != null) {
            builder.addAllMetadatas(json.metadatas);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<Metadata> metadatas = new ArrayList<Metadata>();

        private Builder() {
        }

        public final Builder from(ListMetadatasResponse instance) {
            return this.from((_ListMetadatasResponse)instance);
        }

        final Builder from(_ListMetadatasResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMetadatas(instance.getMetadatas());
            return this;
        }

        public final Builder metadata(Metadata element) {
            this.metadatas.add(Objects.requireNonNull(element, "metadatas element"));
            return this;
        }

        public final Builder metadata(Metadata ... elements) {
            for (Metadata element : elements) {
                this.metadatas.add(Objects.requireNonNull(element, "metadatas element"));
            }
            return this;
        }

        @JsonProperty(value="metadatas")
        public final Builder metadatas(Iterable<? extends Metadata> elements) {
            this.metadatas.clear();
            return this.addAllMetadatas(elements);
        }

        public final Builder addAllMetadatas(Iterable<? extends Metadata> elements) {
            for (Metadata metadata : elements) {
                this.metadatas.add(Objects.requireNonNull(metadata, "metadatas element"));
            }
            return this;
        }

        public ListMetadatasResponse build() {
            return new ListMetadatasResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ListMetadatasResponse {
        List<Metadata> metadatas = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="metadatas")
        public void setMetadatas(List<Metadata> metadatas) {
            this.metadatas = metadatas;
        }

        @Override
        public List<Metadata> getMetadatas() {
            throw new UnsupportedOperationException();
        }
    }
}

