/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.Metadata;
import org.cloudfoundry.uaa.groups.AbstractGroup;
import org.cloudfoundry.uaa.groups.MemberSummary;
import org.cloudfoundry.uaa.groups._Group;

public final class Group
extends _Group {
    @Nullable
    private final String description;
    private final String displayName;
    private final String id;
    private final List<MemberSummary> members;
    private final Metadata metadata;
    private final List<String> schemas;
    private final String zoneId;

    private Group(Builder builder) {
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.id = builder.id;
        this.members = Group.createUnmodifiableList(true, builder.members);
        this.metadata = builder.metadata;
        this.schemas = Group.createUnmodifiableList(true, builder.schemas);
        this.zoneId = builder.zoneId;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="members")
    public List<MemberSummary> getMembers() {
        return this.members;
    }

    @Override
    @JsonProperty(value="meta")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="zoneId")
    public String getZoneId() {
        return this.zoneId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Group && this.equalTo((Group)another);
    }

    private boolean equalTo(Group another) {
        return Objects.equals(this.description, another.description) && this.displayName.equals(another.displayName) && this.id.equals(another.id) && this.members.equals(another.members) && this.metadata.equals(another.metadata) && this.schemas.equals(another.schemas) && this.zoneId.equals(another.zoneId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.zoneId.hashCode();
        return h;
    }

    public String toString() {
        return "Group{description=" + this.description + ", displayName=" + this.displayName + ", id=" + this.id + ", members=" + this.members + ", metadata=" + this.metadata + ", schemas=" + this.schemas + ", zoneId=" + this.zoneId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Group fromJson(Json json) {
        Builder builder = Group.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DISPLAY_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_METADATA = 4L;
        private static final long INIT_BIT_ZONE_ID = 8L;
        private long initBits = 15L;
        private String description;
        private String displayName;
        private String id;
        private List<MemberSummary> members = new ArrayList<MemberSummary>();
        private Metadata metadata;
        private List<String> schemas = new ArrayList<String>();
        private String zoneId;

        private Builder() {
        }

        public final Builder from(AbstractGroup instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Group instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_Group instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractGroup) {
                AbstractGroup instance = (AbstractGroup)object;
                this.metadata(instance.getMetadata());
                this.displayName(instance.getDisplayName());
                this.addAllMembers(instance.getMembers());
                this.addAllSchemas(instance.getSchemas());
                String descriptionValue = instance.getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                this.zoneId(instance.getZoneId());
                this.id(instance.getId());
            }
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="displayName")
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder member(MemberSummary element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder member(MemberSummary ... elements) {
            for (MemberSummary element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends MemberSummary> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
            for (MemberSummary memberSummary : elements) {
                this.members.add(Objects.requireNonNull(memberSummary, "members element"));
            }
            return this;
        }

        @JsonProperty(value="meta")
        public final Builder metadata(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder schema(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder schema(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="schemas")
        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="zoneId")
        public final Builder zoneId(String zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Group build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Group(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("displayName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("zoneId");
            }
            return "Cannot build Group, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Group {
        String description;
        String displayName;
        String id;
        List<MemberSummary> members = Collections.emptyList();
        Metadata metadata;
        List<String> schemas = Collections.emptyList();
        String zoneId;

        Json() {
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="members")
        public void setMembers(List<MemberSummary> members) {
            this.members = members;
        }

        @JsonProperty(value="meta")
        public void setMetadata(Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="zoneId")
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemberSummary> getMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }
    }
}

