/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.uaa.identityzones._Key;

public final class Key
extends _Key {
    private final String certificate;

    private Key(Builder builder) {
        this.certificate = builder.certificate;
    }

    @Override
    @JsonProperty(value="certificate")
    public String getCertificate() {
        return this.certificate;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Key && this.equalTo((Key)another);
    }

    private boolean equalTo(Key another) {
        return this.certificate.equals(another.certificate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.certificate.hashCode();
        return h;
    }

    public String toString() {
        return "Key{certificate=" + this.certificate + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Key fromJson(Json json) {
        Builder builder = Key.builder();
        if (json.certificate != null) {
            builder.certificate(json.certificate);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CERTIFICATE = 1L;
        private long initBits = 1L;
        private String certificate;

        private Builder() {
        }

        public final Builder from(Key instance) {
            return this.from((_Key)instance);
        }

        final Builder from(_Key instance) {
            Objects.requireNonNull(instance, "instance");
            this.certificate(instance.getCertificate());
            return this;
        }

        @JsonProperty(value="certificate")
        public final Builder certificate(String certificate) {
            this.certificate = Objects.requireNonNull(certificate, "certificate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Key build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Key(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("certificate");
            }
            return "Cannot build Key, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Key {
        String certificate;

        Json() {
        }

        @JsonProperty(value="certificate")
        public void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public String getCertificate() {
            throw new UnsupportedOperationException();
        }
    }
}

