/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.identityzones._LogoutLink;

public final class LogoutLink
extends _LogoutLink {
    @Nullable
    private final Boolean disableRedirectParameter;
    @Nullable
    private final String redirectParameterName;
    @Nullable
    private final String redirectUrl;
    @Nullable
    private final List<String> whitelist;

    private LogoutLink(Builder builder) {
        this.disableRedirectParameter = builder.disableRedirectParameter;
        this.redirectParameterName = builder.redirectParameterName;
        this.redirectUrl = builder.redirectUrl;
        this.whitelist = builder.whitelist == null ? null : LogoutLink.createUnmodifiableList(true, builder.whitelist);
    }

    @Override
    @JsonProperty(value="disableRedirectParameter")
    @Nullable
    public Boolean getDisableRedirectParameter() {
        return this.disableRedirectParameter;
    }

    @Override
    @JsonProperty(value="redirectParameterName")
    @Nullable
    public String getRedirectParameterName() {
        return this.redirectParameterName;
    }

    @Override
    @JsonProperty(value="redirectUrl")
    @Nullable
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @Override
    @JsonProperty(value="whitelist")
    @Nullable
    public List<String> getWhitelist() {
        return this.whitelist;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LogoutLink && this.equalTo((LogoutLink)another);
    }

    private boolean equalTo(LogoutLink another) {
        return Objects.equals(this.disableRedirectParameter, another.disableRedirectParameter) && Objects.equals(this.redirectParameterName, another.redirectParameterName) && Objects.equals(this.redirectUrl, another.redirectUrl) && Objects.equals(this.whitelist, another.whitelist);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.disableRedirectParameter);
        h += (h << 5) + Objects.hashCode(this.redirectParameterName);
        h += (h << 5) + Objects.hashCode(this.redirectUrl);
        h += (h << 5) + Objects.hashCode(this.whitelist);
        return h;
    }

    public String toString() {
        return "LogoutLink{disableRedirectParameter=" + this.disableRedirectParameter + ", redirectParameterName=" + this.redirectParameterName + ", redirectUrl=" + this.redirectUrl + ", whitelist=" + this.whitelist + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static LogoutLink fromJson(Json json) {
        Builder builder = LogoutLink.builder();
        if (json.disableRedirectParameter != null) {
            builder.disableRedirectParameter(json.disableRedirectParameter);
        }
        if (json.redirectParameterName != null) {
            builder.redirectParameterName(json.redirectParameterName);
        }
        if (json.redirectUrl != null) {
            builder.redirectUrl(json.redirectUrl);
        }
        if (json.whitelist != null) {
            builder.addAllWhitelist(json.whitelist);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Boolean disableRedirectParameter;
        private String redirectParameterName;
        private String redirectUrl;
        private List<String> whitelist = null;

        private Builder() {
        }

        public final Builder from(LogoutLink instance) {
            return this.from((_LogoutLink)instance);
        }

        final Builder from(_LogoutLink instance) {
            List<String> whitelistValue;
            String redirectUrlValue;
            String redirectParameterNameValue;
            Objects.requireNonNull(instance, "instance");
            Boolean disableRedirectParameterValue = instance.getDisableRedirectParameter();
            if (disableRedirectParameterValue != null) {
                this.disableRedirectParameter(disableRedirectParameterValue);
            }
            if ((redirectParameterNameValue = instance.getRedirectParameterName()) != null) {
                this.redirectParameterName(redirectParameterNameValue);
            }
            if ((redirectUrlValue = instance.getRedirectUrl()) != null) {
                this.redirectUrl(redirectUrlValue);
            }
            if ((whitelistValue = instance.getWhitelist()) != null) {
                this.addAllWhitelist(whitelistValue);
            }
            return this;
        }

        @JsonProperty(value="disableRedirectParameter")
        public final Builder disableRedirectParameter(@Nullable Boolean disableRedirectParameter) {
            this.disableRedirectParameter = disableRedirectParameter;
            return this;
        }

        @JsonProperty(value="redirectParameterName")
        public final Builder redirectParameterName(@Nullable String redirectParameterName) {
            this.redirectParameterName = redirectParameterName;
            return this;
        }

        @JsonProperty(value="redirectUrl")
        public final Builder redirectUrl(@Nullable String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public final Builder whitelist(String element) {
            if (this.whitelist == null) {
                this.whitelist = new ArrayList<String>();
            }
            this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
            return this;
        }

        public final Builder whitelist(String ... elements) {
            if (this.whitelist == null) {
                this.whitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
            }
            return this;
        }

        @JsonProperty(value="whitelist")
        public final Builder whitelist(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.whitelist = null;
                return this;
            }
            this.whitelist = new ArrayList<String>();
            return this.addAllWhitelist(elements);
        }

        public final Builder addAllWhitelist(Iterable<String> elements) {
            Objects.requireNonNull(elements, "whitelist element");
            if (this.whitelist == null) {
                this.whitelist = new ArrayList<String>();
            }
            for (String element : elements) {
                this.whitelist.add(Objects.requireNonNull(element, "whitelist element"));
            }
            return this;
        }

        public LogoutLink build() {
            return new LogoutLink(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _LogoutLink {
        Boolean disableRedirectParameter;
        String redirectParameterName;
        String redirectUrl;
        List<String> whitelist = null;

        Json() {
        }

        @JsonProperty(value="disableRedirectParameter")
        public void setDisableRedirectParameter(@Nullable Boolean disableRedirectParameter) {
            this.disableRedirectParameter = disableRedirectParameter;
        }

        @JsonProperty(value="redirectParameterName")
        public void setRedirectParameterName(@Nullable String redirectParameterName) {
            this.redirectParameterName = redirectParameterName;
        }

        @JsonProperty(value="redirectUrl")
        public void setRedirectUrl(@Nullable String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        @JsonProperty(value="whitelist")
        public void setWhitelist(@Nullable List<String> whitelist) {
            this.whitelist = whitelist;
        }

        @Override
        public Boolean getDisableRedirectParameter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectParameterName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getWhitelist() {
            throw new UnsupportedOperationException();
        }
    }
}

