/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.users._Invite;

public final class Invite
extends _Invite {
    private final String email;
    @Nullable
    private final String errorCode;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final String inviteLink;
    @Nullable
    private final String origin;
    private final Boolean success;
    @Nullable
    private final String userId;

    private Invite(Builder builder) {
        this.email = builder.email;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.inviteLink = builder.inviteLink;
        this.origin = builder.origin;
        this.success = builder.success;
        this.userId = builder.userId;
    }

    @Override
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="errorCode")
    @Nullable
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="errorMessage")
    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="inviteLink")
    @Nullable
    public String getInviteLink() {
        return this.inviteLink;
    }

    @Override
    @JsonProperty(value="origin")
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="success")
    public Boolean getSuccess() {
        return this.success;
    }

    @Override
    @JsonProperty(value="userId")
    @Nullable
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Invite && this.equalTo((Invite)another);
    }

    private boolean equalTo(Invite another) {
        return this.email.equals(another.email) && Objects.equals(this.errorCode, another.errorCode) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.inviteLink, another.inviteLink) && Objects.equals(this.origin, another.origin) && this.success.equals(another.success) && Objects.equals(this.userId, another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorCode);
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        h += (h << 5) + Objects.hashCode(this.inviteLink);
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + this.success.hashCode();
        h += (h << 5) + Objects.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "Invite{email=" + this.email + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", inviteLink=" + this.inviteLink + ", origin=" + this.origin + ", success=" + this.success + ", userId=" + this.userId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Invite fromJson(Json json) {
        Builder builder = Invite.builder();
        if (json.email != null) {
            builder.email(json.email);
        }
        if (json.errorCode != null) {
            builder.errorCode(json.errorCode);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.inviteLink != null) {
            builder.inviteLink(json.inviteLink);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.success != null) {
            builder.success(json.success);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMAIL = 1L;
        private static final long INIT_BIT_SUCCESS = 2L;
        private long initBits = 3L;
        private String email;
        private String errorCode;
        private String errorMessage;
        private String inviteLink;
        private String origin;
        private Boolean success;
        private String userId;

        private Builder() {
        }

        public final Builder from(Invite instance) {
            return this.from((_Invite)instance);
        }

        final Builder from(_Invite instance) {
            String originValue;
            String inviteLinkValue;
            String errorMessageValue;
            Objects.requireNonNull(instance, "instance");
            this.email(instance.getEmail());
            String errorCodeValue = instance.getErrorCode();
            if (errorCodeValue != null) {
                this.errorCode(errorCodeValue);
            }
            if ((errorMessageValue = instance.getErrorMessage()) != null) {
                this.errorMessage(errorMessageValue);
            }
            if ((inviteLinkValue = instance.getInviteLink()) != null) {
                this.inviteLink(inviteLinkValue);
            }
            if ((originValue = instance.getOrigin()) != null) {
                this.origin(originValue);
            }
            this.success(instance.getSuccess());
            String userIdValue = instance.getUserId();
            if (userIdValue != null) {
                this.userId(userIdValue);
            }
            return this;
        }

        @JsonProperty(value="email")
        public final Builder email(String email) {
            this.email = Objects.requireNonNull(email, "email");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="errorCode")
        public final Builder errorCode(@Nullable String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty(value="errorMessage")
        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty(value="inviteLink")
        public final Builder inviteLink(@Nullable String inviteLink) {
            this.inviteLink = inviteLink;
            return this;
        }

        @JsonProperty(value="origin")
        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        @JsonProperty(value="success")
        public final Builder success(Boolean success) {
            this.success = Objects.requireNonNull(success, "success");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="userId")
        public final Builder userId(@Nullable String userId) {
            this.userId = userId;
            return this;
        }

        public Invite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Invite(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("email");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("success");
            }
            return "Cannot build Invite, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Invite {
        String email;
        String errorCode;
        String errorMessage;
        String inviteLink;
        String origin;
        Boolean success;
        String userId;

        Json() {
        }

        @JsonProperty(value="email")
        public void setEmail(String email) {
            this.email = email;
        }

        @JsonProperty(value="errorCode")
        public void setErrorCode(@Nullable String errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="inviteLink")
        public void setInviteLink(@Nullable String inviteLink) {
            this.inviteLink = inviteLink;
        }

        @JsonProperty(value="origin")
        public void setOrigin(@Nullable String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="success")
        public void setSuccess(Boolean success) {
            this.success = success;
        }

        @JsonProperty(value="userId")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getInviteLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

