/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;
import org.cloudfoundry.uaa.users._VerifyUserRequest;

public final class VerifyUserRequest
extends _VerifyUserRequest {
    private final String userId;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;
    @Nullable
    private final String version;

    private VerifyUserRequest(Builder builder) {
        this.userId = builder.userId;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
        this.version = builder.version;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VerifyUserRequest && this.equalTo((VerifyUserRequest)another);
    }

    private boolean equalTo(VerifyUserRequest another) {
        return this.userId.equals(another.userId) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "VerifyUserRequest{userId=" + this.userId + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + ", version=" + this.version + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private long initBits = 1L;
        private String userId;
        private String identityZoneId;
        private String identityZoneSubdomain;
        private String version;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Versioned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(VerifyUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_VerifyUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String versionValue;
            Object instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof Versioned && (versionValue = (instance = (Versioned)object).getVersion()) != null) {
                this.version(versionValue);
            }
            if (object instanceof _VerifyUserRequest) {
                instance = (_VerifyUserRequest)object;
                this.userId(((_VerifyUserRequest)instance).getUserId());
            }
        }

        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public VerifyUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new VerifyUserRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            return "Cannot build VerifyUserRequest, some of required attributes are not set " + attributes;
        }
    }
}

