/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.auditevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.cloudfoundry.client.v3.auditevents.AuditEvent;
import org.cloudfoundry.client.v3.auditevents.AuditEventActor;
import org.cloudfoundry.client.v3.auditevents.AuditEventTarget;
import org.cloudfoundry.client.v3.auditevents._AuditEventResource;
import org.immutables.value.Generated;

@Generated(from="_AuditEventResource", generator="Immutables")
public final class AuditEventResource
extends _AuditEventResource {
    private final String createdAt;
    private final String id;
    private final Map<String, Link> links;
    @Nullable
    private final String updatedAt;
    @Nullable
    private final AuditEventActor auditEventActor;
    @Nullable
    private final AuditEventTarget auditEventTarget;
    @Nullable
    private final Map<String, Object> data;
    @Nullable
    private final Relationship organizationRelationship;
    @Nullable
    private final Relationship spaceRelationship;
    @Nullable
    private final String type;

    private AuditEventResource(Builder builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.links = AuditEventResource.createUnmodifiableMap(false, false, builder.links);
        this.updatedAt = builder.updatedAt;
        this.auditEventActor = builder.auditEventActor;
        this.auditEventTarget = builder.auditEventTarget;
        this.data = builder.data == null ? null : AuditEventResource.createUnmodifiableMap(false, false, builder.data);
        this.organizationRelationship = builder.organizationRelationship;
        this.spaceRelationship = builder.spaceRelationship;
        this.type = builder.type;
    }

    @Override
    @JsonProperty(value="created_at")
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="guid")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="links")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="updated_at")
    @Nullable
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="actor")
    @Nullable
    public AuditEventActor getAuditEventActor() {
        return this.auditEventActor;
    }

    @Override
    @JsonProperty(value="target")
    @Nullable
    public AuditEventTarget getAuditEventTarget() {
        return this.auditEventTarget;
    }

    @Override
    @JsonProperty(value="data")
    @Nullable
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="organization")
    @Nullable
    public Relationship getOrganizationRelationship() {
        return this.organizationRelationship;
    }

    @Override
    @JsonProperty(value="space")
    @Nullable
    public Relationship getSpaceRelationship() {
        return this.spaceRelationship;
    }

    @Override
    @JsonProperty(value="type")
    @Nullable
    public String getType() {
        return this.type;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuditEventResource && this.equalTo((AuditEventResource)another);
    }

    private boolean equalTo(AuditEventResource another) {
        return this.createdAt.equals(another.createdAt) && this.id.equals(another.id) && this.links.equals(another.links) && Objects.equals(this.updatedAt, another.updatedAt) && Objects.equals(this.auditEventActor, another.auditEventActor) && Objects.equals(this.auditEventTarget, another.auditEventTarget) && Objects.equals(this.data, another.data) && Objects.equals(this.organizationRelationship, another.organizationRelationship) && Objects.equals(this.spaceRelationship, another.spaceRelationship) && Objects.equals(this.type, another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.updatedAt);
        h += (h << 5) + Objects.hashCode(this.auditEventActor);
        h += (h << 5) + Objects.hashCode(this.auditEventTarget);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.organizationRelationship);
        h += (h << 5) + Objects.hashCode(this.spaceRelationship);
        h += (h << 5) + Objects.hashCode(this.type);
        return h;
    }

    public String toString() {
        return "AuditEventResource{createdAt=" + this.createdAt + ", id=" + this.id + ", links=" + this.links + ", updatedAt=" + this.updatedAt + ", auditEventActor=" + this.auditEventActor + ", auditEventTarget=" + this.auditEventTarget + ", data=" + this.data + ", organizationRelationship=" + this.organizationRelationship + ", spaceRelationship=" + this.spaceRelationship + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AuditEventResource fromJson(Json json) {
        Builder builder = AuditEventResource.builder();
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.updatedAt != null) {
            builder.updatedAt(json.updatedAt);
        }
        if (json.auditEventActor != null) {
            builder.auditEventActor(json.auditEventActor);
        }
        if (json.auditEventTarget != null) {
            builder.auditEventTarget(json.auditEventTarget);
        }
        if (json.data != null) {
            builder.putAllData(json.data);
        }
        if (json.organizationRelationship != null) {
            builder.organizationRelationship(json.organizationRelationship);
        }
        if (json.spaceRelationship != null) {
            builder.spaceRelationship(json.spaceRelationship);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_AuditEventResource", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CREATED_AT = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        private String createdAt;
        private String id;
        private Map<String, Link> links = new LinkedHashMap<String, Link>();
        private String updatedAt;
        private AuditEventActor auditEventActor;
        private AuditEventTarget auditEventTarget;
        private Map<String, Object> data = null;
        private Relationship organizationRelationship;
        private Relationship spaceRelationship;
        private String type;

        private Builder() {
        }

        public final Builder from(AuditEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Resource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AuditEventResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_AuditEventResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Resource instance;
            if (object instanceof AuditEvent) {
                Relationship spaceRelationshipValue;
                String typeValue;
                Map<String, Object> dataValue;
                AuditEventActor auditEventActorValue;
                AuditEventTarget auditEventTargetValue;
                instance = (AuditEvent)object;
                Relationship organizationRelationshipValue = ((AuditEvent)instance).getOrganizationRelationship();
                if (organizationRelationshipValue != null) {
                    this.organizationRelationship(organizationRelationshipValue);
                }
                if ((auditEventTargetValue = ((AuditEvent)instance).getAuditEventTarget()) != null) {
                    this.auditEventTarget(auditEventTargetValue);
                }
                if ((auditEventActorValue = ((AuditEvent)instance).getAuditEventActor()) != null) {
                    this.auditEventActor(auditEventActorValue);
                }
                if ((dataValue = ((AuditEvent)instance).getData()) != null) {
                    this.putAllData(dataValue);
                }
                if ((typeValue = ((AuditEvent)instance).getType()) != null) {
                    this.type(typeValue);
                }
                if ((spaceRelationshipValue = ((AuditEvent)instance).getSpaceRelationship()) != null) {
                    this.spaceRelationship(spaceRelationshipValue);
                }
            }
            if (object instanceof Resource) {
                instance = (Resource)object;
                this.createdAt(instance.getCreatedAt());
                this.putAllLinks(instance.getLinks());
                this.id(instance.getId());
                String updatedAtValue = instance.getUpdatedAt();
                if (updatedAtValue != null) {
                    this.updatedAt(updatedAtValue);
                }
            }
        }

        @JsonProperty(value="created_at")
        public final Builder createdAt(String createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder link(String key, Link value) {
            this.links.put(key, value);
            return this;
        }

        public final Builder link(Map.Entry<String, ? extends Link> entry) {
            String k = entry.getKey();
            Link v = entry.getValue();
            this.links.put(k, v);
            return this;
        }

        @JsonProperty(value="links")
        public final Builder links(Map<String, ? extends Link> entries) {
            this.links.clear();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends Link> entries) {
            for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
                String k = e.getKey();
                Link v = e.getValue();
                this.links.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="updated_at")
        public final Builder updatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="actor")
        public final Builder auditEventActor(@Nullable AuditEventActor auditEventActor) {
            this.auditEventActor = auditEventActor;
            return this;
        }

        @JsonProperty(value="target")
        public final Builder auditEventTarget(@Nullable AuditEventTarget auditEventTarget) {
            this.auditEventTarget = auditEventTarget;
            return this;
        }

        public final Builder data(String key, Object value) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
            this.data.put(key, value);
            return this;
        }

        public final Builder data(Map.Entry<String, ? extends Object> entry) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.data.put(k, v);
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.data = null;
                return this;
            }
            this.data = new LinkedHashMap<String, Object>();
            return this.putAllData(entries);
        }

        public final Builder putAllData(Map<String, ? extends Object> entries) {
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.data.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="organization")
        public final Builder organizationRelationship(@Nullable Relationship organizationRelationship) {
            this.organizationRelationship = organizationRelationship;
            return this;
        }

        @JsonProperty(value="space")
        public final Builder spaceRelationship(@Nullable Relationship spaceRelationship) {
            this.spaceRelationship = spaceRelationship;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        public AuditEventResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AuditEventResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build AuditEventResource, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_AuditEventResource", generator="Immutables")
    static final class Json
    extends _AuditEventResource {
        String createdAt;
        String id;
        Map<String, Link> links = Collections.emptyMap();
        String updatedAt;
        AuditEventActor auditEventActor;
        AuditEventTarget auditEventTarget;
        Map<String, Object> data = null;
        Relationship organizationRelationship;
        Relationship spaceRelationship;
        String type;

        Json() {
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="guid")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, Link> links) {
            this.links = links;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="actor")
        public void setAuditEventActor(@Nullable AuditEventActor auditEventActor) {
            this.auditEventActor = auditEventActor;
        }

        @JsonProperty(value="target")
        public void setAuditEventTarget(@Nullable AuditEventTarget auditEventTarget) {
            this.auditEventTarget = auditEventTarget;
        }

        @JsonProperty(value="data")
        public void setData(@Nullable Map<String, Object> data) {
            this.data = data;
        }

        @JsonProperty(value="organization")
        public void setOrganizationRelationship(@Nullable Relationship organizationRelationship) {
            this.organizationRelationship = organizationRelationship;
        }

        @JsonProperty(value="space")
        public void setSpaceRelationship(@Nullable Relationship spaceRelationship) {
            this.spaceRelationship = spaceRelationship;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @Override
        public String getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AuditEventActor getAuditEventActor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AuditEventTarget getAuditEventTarget() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getOrganizationRelationship() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Relationship getSpaceRelationship() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

