/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.deployments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DeploymentStatusReason {
    CANCELED("CANCELED"),
    CANCELING("CANCELING"),
    DEGENERATE("DEGENERATE"),
    DEPLOYED("DEPLOYED"),
    DEPLOYING("DEPLOYING"),
    SUPERSEDED("SUPERSEDED");

    private final String value;

    private DeploymentStatusReason(String value) {
        this.value = value;
    }

    @JsonCreator
    public static DeploymentStatusReason from(String s) {
        switch (s.toLowerCase()) {
            case "canceled": {
                return CANCELED;
            }
            case "canceling": {
                return CANCELING;
            }
            case "degenerate": {
                return DEGENERATE;
            }
            case "deployed": {
                return DEPLOYED;
            }
            case "deploying": {
                return DEPLOYING;
            }
            case "superseded": {
                return SUPERSEDED;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown deployment state: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

