/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import org.cloudfoundry.client.v3.processes.ProcessState;
import org.cloudfoundry.client.v3.processes.ProcessStatistics;
import org.immutables.value.Value;

@JsonDeserialize
@Value.Immutable
abstract class _ProcessStatisticsResource
extends ProcessStatistics {
    _ProcessStatisticsResource() {
    }

    @Value.Check
    protected void check() {
        if (this.getState() == ProcessState.STARTING || this.getState() == ProcessState.RUNNING || this.getState() == ProcessState.CRASHED) {
            ArrayList<String> missing = new ArrayList<String>();
            if (this.getDiskQuota() == null) {
                missing.add("diskQuota");
            }
            if (this.getFileDescriptorQuota() == null) {
                missing.add("fileDescriptorQuota");
            }
            if (this.getHost() == null) {
                missing.add("host");
            }
            if (this.getMemoryQuota() == null) {
                missing.add("memoryQuota");
            }
            if (this.getUsage() == null) {
                missing.add("usage");
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Cannot build ProcessStatisticsResource, some of required attributes are not set " + missing);
            }
        }
    }
}

