/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.Method;
import org.cloudfoundry.doppler.PeerType;
import org.cloudfoundry.doppler._HttpStartStop;
import org.immutables.value.Generated;

@Generated(from="_HttpStartStop", generator="Immutables")
public final class HttpStartStop
extends _HttpStartStop {
    @Nullable
    private final UUID applicationId;
    private final Long contentLength;
    private final List<String> forwarded;
    @Nullable
    private final String instanceId;
    @Nullable
    private final Integer instanceIndex;
    @Nullable
    private final Method method;
    private final PeerType peerType;
    private final String remoteAddress;
    private final UUID requestId;
    private final Long startTimestamp;
    private final Integer statusCode;
    private final Long stopTimestamp;
    private final String uri;
    private final String userAgent;

    private HttpStartStop(Builder builder) {
        this.applicationId = builder.applicationId;
        this.contentLength = builder.contentLength;
        this.forwarded = HttpStartStop.createUnmodifiableList(true, builder.forwarded);
        this.instanceId = builder.instanceId;
        this.instanceIndex = builder.instanceIndex;
        this.method = builder.method;
        this.peerType = builder.peerType;
        this.remoteAddress = builder.remoteAddress;
        this.requestId = builder.requestId;
        this.startTimestamp = builder.startTimestamp;
        this.statusCode = builder.statusCode;
        this.stopTimestamp = builder.stopTimestamp;
        this.uri = builder.uri;
        this.userAgent = builder.userAgent;
    }

    @Override
    @Nullable
    public UUID getApplicationId() {
        return this.applicationId;
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public List<String> getForwarded() {
        return this.forwarded;
    }

    @Override
    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    @Nullable
    public Integer getInstanceIndex() {
        return this.instanceIndex;
    }

    @Override
    @Nullable
    public Method getMethod() {
        return this.method;
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public UUID getRequestId() {
        return this.requestId;
    }

    @Override
    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Long getStopTimestamp() {
        return this.stopTimestamp;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HttpStartStop && this.equalTo((HttpStartStop)another);
    }

    private boolean equalTo(HttpStartStop another) {
        return Objects.equals(this.applicationId, another.applicationId) && this.contentLength.equals(another.contentLength) && this.forwarded.equals(another.forwarded) && Objects.equals(this.instanceId, another.instanceId) && Objects.equals(this.instanceIndex, another.instanceIndex) && Objects.equals((Object)this.method, (Object)another.method) && this.peerType.equals((Object)another.peerType) && this.remoteAddress.equals(another.remoteAddress) && this.requestId.equals(another.requestId) && this.startTimestamp.equals(another.startTimestamp) && this.statusCode.equals(another.statusCode) && this.stopTimestamp.equals(another.stopTimestamp) && this.uri.equals(another.uri) && this.userAgent.equals(another.userAgent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.applicationId);
        h += (h << 5) + this.contentLength.hashCode();
        h += (h << 5) + this.forwarded.hashCode();
        h += (h << 5) + Objects.hashCode(this.instanceId);
        h += (h << 5) + Objects.hashCode(this.instanceIndex);
        h += (h << 5) + Objects.hashCode((Object)this.method);
        h += (h << 5) + this.peerType.hashCode();
        h += (h << 5) + this.remoteAddress.hashCode();
        h += (h << 5) + this.requestId.hashCode();
        h += (h << 5) + this.startTimestamp.hashCode();
        h += (h << 5) + this.statusCode.hashCode();
        h += (h << 5) + this.stopTimestamp.hashCode();
        h += (h << 5) + this.uri.hashCode();
        h += (h << 5) + this.userAgent.hashCode();
        return h;
    }

    public String toString() {
        return "HttpStartStop{applicationId=" + this.applicationId + ", contentLength=" + this.contentLength + ", forwarded=" + this.forwarded + ", instanceId=" + this.instanceId + ", instanceIndex=" + this.instanceIndex + ", method=" + (Object)((Object)this.method) + ", peerType=" + (Object)((Object)this.peerType) + ", remoteAddress=" + this.remoteAddress + ", requestId=" + this.requestId + ", startTimestamp=" + this.startTimestamp + ", statusCode=" + this.statusCode + ", stopTimestamp=" + this.stopTimestamp + ", uri=" + this.uri + ", userAgent=" + this.userAgent + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_HttpStartStop", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_LENGTH = 1L;
        private static final long INIT_BIT_PEER_TYPE = 2L;
        private static final long INIT_BIT_REMOTE_ADDRESS = 4L;
        private static final long INIT_BIT_REQUEST_ID = 8L;
        private static final long INIT_BIT_START_TIMESTAMP = 16L;
        private static final long INIT_BIT_STATUS_CODE = 32L;
        private static final long INIT_BIT_STOP_TIMESTAMP = 64L;
        private static final long INIT_BIT_URI = 128L;
        private static final long INIT_BIT_USER_AGENT = 256L;
        private long initBits = 511L;
        private UUID applicationId;
        private Long contentLength;
        private List<String> forwarded = new ArrayList<String>();
        private String instanceId;
        private Integer instanceIndex;
        private Method method;
        private PeerType peerType;
        private String remoteAddress;
        private UUID requestId;
        private Long startTimestamp;
        private Integer statusCode;
        private Long stopTimestamp;
        private String uri;
        private String userAgent;

        private Builder() {
        }

        public final Builder from(HttpStartStop instance) {
            return this.from((_HttpStartStop)instance);
        }

        final Builder from(_HttpStartStop instance) {
            Method methodValue;
            Integer instanceIndexValue;
            Objects.requireNonNull(instance, "instance");
            UUID applicationIdValue = instance.getApplicationId();
            if (applicationIdValue != null) {
                this.applicationId(applicationIdValue);
            }
            this.contentLength(instance.getContentLength());
            this.addAllForwarded(instance.getForwarded());
            String instanceIdValue = instance.getInstanceId();
            if (instanceIdValue != null) {
                this.instanceId(instanceIdValue);
            }
            if ((instanceIndexValue = instance.getInstanceIndex()) != null) {
                this.instanceIndex(instanceIndexValue);
            }
            if ((methodValue = instance.getMethod()) != null) {
                this.method(methodValue);
            }
            this.peerType(instance.getPeerType());
            this.remoteAddress(instance.getRemoteAddress());
            this.requestId(instance.getRequestId());
            this.startTimestamp(instance.getStartTimestamp());
            this.statusCode(instance.getStatusCode());
            this.stopTimestamp(instance.getStopTimestamp());
            this.uri(instance.getUri());
            this.userAgent(instance.getUserAgent());
            return this;
        }

        public final Builder applicationId(@Nullable UUID applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final Builder contentLength(Long contentLength) {
            this.contentLength = Objects.requireNonNull(contentLength, "contentLength");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder forwarded(String element) {
            this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
            return this;
        }

        public final Builder forwarded(String ... elements) {
            for (String element : elements) {
                this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
            }
            return this;
        }

        public final Builder forwarded(Iterable<String> elements) {
            this.forwarded.clear();
            return this.addAllForwarded(elements);
        }

        public final Builder addAllForwarded(Iterable<String> elements) {
            for (String element : elements) {
                this.forwarded.add(Objects.requireNonNull(element, "forwarded element"));
            }
            return this;
        }

        public final Builder instanceId(@Nullable String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Builder instanceIndex(@Nullable Integer instanceIndex) {
            this.instanceIndex = instanceIndex;
            return this;
        }

        public final Builder method(@Nullable Method method) {
            this.method = method;
            return this;
        }

        public final Builder peerType(PeerType peerType) {
            this.peerType = Objects.requireNonNull(peerType, "peerType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder remoteAddress(String remoteAddress) {
            this.remoteAddress = Objects.requireNonNull(remoteAddress, "remoteAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder requestId(UUID requestId) {
            this.requestId = Objects.requireNonNull(requestId, "requestId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder startTimestamp(Long startTimestamp) {
            this.startTimestamp = Objects.requireNonNull(startTimestamp, "startTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder statusCode(Integer statusCode) {
            this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder stopTimestamp(Long stopTimestamp) {
            this.stopTimestamp = Objects.requireNonNull(stopTimestamp, "stopTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder uri(String uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder userAgent(String userAgent) {
            this.userAgent = Objects.requireNonNull(userAgent, "userAgent");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public HttpStartStop build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new HttpStartStop(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentLength");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("peerType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("remoteAddress");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("requestId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("startTimestamp");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("statusCode");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("stopTimestamp");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("uri");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("userAgent");
            }
            return "Cannot build HttpStartStop, some of required attributes are not set " + attributes;
        }
    }
}

