package org.cloudfoundry.operations;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.advanced.Advanced;
import org.cloudfoundry.operations.applications.Applications;
import org.cloudfoundry.operations.buildpacks.Buildpacks;
import org.cloudfoundry.operations.domains.Domains;
import org.cloudfoundry.operations.organizationadmin.OrganizationAdmin;
import org.cloudfoundry.operations.organizations.Organizations;
import org.cloudfoundry.operations.routes.Routes;
import org.cloudfoundry.operations.serviceadmin.ServiceAdmin;
import org.cloudfoundry.operations.services.Services;
import org.cloudfoundry.operations.spaceadmin.SpaceAdmin;
import org.cloudfoundry.operations.spaces.Spaces;
import org.cloudfoundry.operations.stacks.Stacks;
import org.cloudfoundry.uaa.UaaClient;
import reactor.core.publisher.Mono;

/**
 * Immutable implementation of {@link _DefaultCloudFoundryOperations}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DefaultCloudFoundryOperations.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DefaultCloudFoundryOperations"})
public final class DefaultCloudFoundryOperations
    extends org.cloudfoundry.operations._DefaultCloudFoundryOperations {
  private final Advanced advanced;
  private final Applications applications;
  private final Buildpacks buildpacks;
  private final Domains domains;
  private final OrganizationAdmin organizationAdmin;
  private final Organizations organizations;
  private final Routes routes;
  private final ServiceAdmin serviceAdmin;
  private final Services services;
  private final SpaceAdmin spaceAdmin;
  private final Spaces spaces;
  private final Stacks stacks;
  private final @Nullable CloudFoundryClient cloudFoundryClient;
  private final Mono<CloudFoundryClient> cloudFoundryClientPublisher;
  private final @Nullable DopplerClient dopplerClient;
  private final Mono<DopplerClient> dopplerClientPublisher;
  private final @Nullable String organization;
  private final Mono<String> organizationId;
  private final @Nullable String space;
  private final Mono<String> spaceId;
  private final @Nullable UaaClient uaaClient;
  private final Mono<UaaClient> uaaClientPublisher;
  private final Mono<String> username;

  private DefaultCloudFoundryOperations(DefaultCloudFoundryOperations.Builder builder) {
    this.cloudFoundryClient = builder.cloudFoundryClient;
    this.dopplerClient = builder.dopplerClient;
    this.organization = builder.organization;
    this.space = builder.space;
    this.uaaClient = builder.uaaClient;
    this.advanced = initShim.advanced();
    this.applications = initShim.applications();
    this.buildpacks = initShim.buildpacks();
    this.domains = initShim.domains();
    this.organizationAdmin = initShim.organizationAdmin();
    this.organizations = initShim.organizations();
    this.routes = initShim.routes();
    this.serviceAdmin = initShim.serviceAdmin();
    this.services = initShim.services();
    this.spaceAdmin = initShim.spaceAdmin();
    this.spaces = initShim.spaces();
    this.stacks = initShim.stacks();
    this.cloudFoundryClientPublisher = initShim.getCloudFoundryClientPublisher();
    this.dopplerClientPublisher = initShim.getDopplerClientPublisher();
    this.organizationId = initShim.getOrganizationId();
    this.spaceId = initShim.getSpaceId();
    this.uaaClientPublisher = initShim.getUaaClientPublisher();
    this.username = initShim.getUsername();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private Advanced advanced;
    private int advancedStage;

    Advanced advanced() {
      if (advancedStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (advancedStage == STAGE_UNINITIALIZED) {
        advancedStage = STAGE_INITIALIZING;
        this.advanced = Objects.requireNonNull(DefaultCloudFoundryOperations.super.advanced(), "advanced");
        advancedStage = STAGE_INITIALIZED;
      }
      return this.advanced;
    }
    private Applications applications;
    private int applicationsStage;

    Applications applications() {
      if (applicationsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (applicationsStage == STAGE_UNINITIALIZED) {
        applicationsStage = STAGE_INITIALIZING;
        this.applications = Objects.requireNonNull(DefaultCloudFoundryOperations.super.applications(), "applications");
        applicationsStage = STAGE_INITIALIZED;
      }
      return this.applications;
    }
    private Buildpacks buildpacks;
    private int buildpacksStage;

    Buildpacks buildpacks() {
      if (buildpacksStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (buildpacksStage == STAGE_UNINITIALIZED) {
        buildpacksStage = STAGE_INITIALIZING;
        this.buildpacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.buildpacks(), "buildpacks");
        buildpacksStage = STAGE_INITIALIZED;
      }
      return this.buildpacks;
    }
    private Domains domains;
    private int domainsStage;

    Domains domains() {
      if (domainsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (domainsStage == STAGE_UNINITIALIZED) {
        domainsStage = STAGE_INITIALIZING;
        this.domains = Objects.requireNonNull(DefaultCloudFoundryOperations.super.domains(), "domains");
        domainsStage = STAGE_INITIALIZED;
      }
      return this.domains;
    }
    private OrganizationAdmin organizationAdmin;
    private int organizationAdminStage;

    OrganizationAdmin organizationAdmin() {
      if (organizationAdminStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationAdminStage == STAGE_UNINITIALIZED) {
        organizationAdminStage = STAGE_INITIALIZING;
        this.organizationAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizationAdmin(), "organizationAdmin");
        organizationAdminStage = STAGE_INITIALIZED;
      }
      return this.organizationAdmin;
    }
    private Organizations organizations;
    private int organizationsStage;

    Organizations organizations() {
      if (organizationsStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationsStage == STAGE_UNINITIALIZED) {
        organizationsStage = STAGE_INITIALIZING;
        this.organizations = Objects.requireNonNull(DefaultCloudFoundryOperations.super.organizations(), "organizations");
        organizationsStage = STAGE_INITIALIZED;
      }
      return this.organizations;
    }
    private Routes routes;
    private int routesStage;

    Routes routes() {
      if (routesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (routesStage == STAGE_UNINITIALIZED) {
        routesStage = STAGE_INITIALIZING;
        this.routes = Objects.requireNonNull(DefaultCloudFoundryOperations.super.routes(), "routes");
        routesStage = STAGE_INITIALIZED;
      }
      return this.routes;
    }
    private ServiceAdmin serviceAdmin;
    private int serviceAdminStage;

    ServiceAdmin serviceAdmin() {
      if (serviceAdminStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (serviceAdminStage == STAGE_UNINITIALIZED) {
        serviceAdminStage = STAGE_INITIALIZING;
        this.serviceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.serviceAdmin(), "serviceAdmin");
        serviceAdminStage = STAGE_INITIALIZED;
      }
      return this.serviceAdmin;
    }
    private Services services;
    private int servicesStage;

    Services services() {
      if (servicesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (servicesStage == STAGE_UNINITIALIZED) {
        servicesStage = STAGE_INITIALIZING;
        this.services = Objects.requireNonNull(DefaultCloudFoundryOperations.super.services(), "services");
        servicesStage = STAGE_INITIALIZED;
      }
      return this.services;
    }
    private SpaceAdmin spaceAdmin;
    private int spaceAdminStage;

    SpaceAdmin spaceAdmin() {
      if (spaceAdminStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceAdminStage == STAGE_UNINITIALIZED) {
        spaceAdminStage = STAGE_INITIALIZING;
        this.spaceAdmin = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaceAdmin(), "spaceAdmin");
        spaceAdminStage = STAGE_INITIALIZED;
      }
      return this.spaceAdmin;
    }
    private Spaces spaces;
    private int spacesStage;

    Spaces spaces() {
      if (spacesStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spacesStage == STAGE_UNINITIALIZED) {
        spacesStage = STAGE_INITIALIZING;
        this.spaces = Objects.requireNonNull(DefaultCloudFoundryOperations.super.spaces(), "spaces");
        spacesStage = STAGE_INITIALIZED;
      }
      return this.spaces;
    }
    private Stacks stacks;
    private int stacksStage;

    Stacks stacks() {
      if (stacksStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (stacksStage == STAGE_UNINITIALIZED) {
        stacksStage = STAGE_INITIALIZING;
        this.stacks = Objects.requireNonNull(DefaultCloudFoundryOperations.super.stacks(), "stacks");
        stacksStage = STAGE_INITIALIZED;
      }
      return this.stacks;
    }
    private Mono<CloudFoundryClient> cloudFoundryClientPublisher;
    private int cloudFoundryClientPublisherStage;

    Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
      if (cloudFoundryClientPublisherStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cloudFoundryClientPublisherStage == STAGE_UNINITIALIZED) {
        cloudFoundryClientPublisherStage = STAGE_INITIALIZING;
        this.cloudFoundryClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getCloudFoundryClientPublisher(), "cloudFoundryClientPublisher");
        cloudFoundryClientPublisherStage = STAGE_INITIALIZED;
      }
      return this.cloudFoundryClientPublisher;
    }
    private Mono<DopplerClient> dopplerClientPublisher;
    private int dopplerClientPublisherStage;

    Mono<DopplerClient> getDopplerClientPublisher() {
      if (dopplerClientPublisherStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dopplerClientPublisherStage == STAGE_UNINITIALIZED) {
        dopplerClientPublisherStage = STAGE_INITIALIZING;
        this.dopplerClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getDopplerClientPublisher(), "dopplerClientPublisher");
        dopplerClientPublisherStage = STAGE_INITIALIZED;
      }
      return this.dopplerClientPublisher;
    }
    private Mono<String> organizationId;
    private int organizationIdStage;

    Mono<String> getOrganizationId() {
      if (organizationIdStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (organizationIdStage == STAGE_UNINITIALIZED) {
        organizationIdStage = STAGE_INITIALIZING;
        this.organizationId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getOrganizationId(), "organizationId");
        organizationIdStage = STAGE_INITIALIZED;
      }
      return this.organizationId;
    }
    private Mono<String> spaceId;
    private int spaceIdStage;

    Mono<String> getSpaceId() {
      if (spaceIdStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (spaceIdStage == STAGE_UNINITIALIZED) {
        spaceIdStage = STAGE_INITIALIZING;
        this.spaceId = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getSpaceId(), "spaceId");
        spaceIdStage = STAGE_INITIALIZED;
      }
      return this.spaceId;
    }
    private Mono<UaaClient> uaaClientPublisher;
    private int uaaClientPublisherStage;

    Mono<UaaClient> getUaaClientPublisher() {
      if (uaaClientPublisherStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (uaaClientPublisherStage == STAGE_UNINITIALIZED) {
        uaaClientPublisherStage = STAGE_INITIALIZING;
        this.uaaClientPublisher = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUaaClientPublisher(), "uaaClientPublisher");
        uaaClientPublisherStage = STAGE_INITIALIZED;
      }
      return this.uaaClientPublisher;
    }
    private Mono<String> username;
    private int usernameStage;

    Mono<String> getUsername() {
      if (usernameStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (usernameStage == STAGE_UNINITIALIZED) {
        usernameStage = STAGE_INITIALIZING;
        this.username = Objects.requireNonNull(DefaultCloudFoundryOperations.super.getUsername(), "username");
        usernameStage = STAGE_INITIALIZED;
      }
      return this.username;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (advancedStage == STAGE_INITIALIZING) attributes.add("advanced");
      if (applicationsStage == STAGE_INITIALIZING) attributes.add("applications");
      if (buildpacksStage == STAGE_INITIALIZING) attributes.add("buildpacks");
      if (domainsStage == STAGE_INITIALIZING) attributes.add("domains");
      if (organizationAdminStage == STAGE_INITIALIZING) attributes.add("organizationAdmin");
      if (organizationsStage == STAGE_INITIALIZING) attributes.add("organizations");
      if (routesStage == STAGE_INITIALIZING) attributes.add("routes");
      if (serviceAdminStage == STAGE_INITIALIZING) attributes.add("serviceAdmin");
      if (servicesStage == STAGE_INITIALIZING) attributes.add("services");
      if (spaceAdminStage == STAGE_INITIALIZING) attributes.add("spaceAdmin");
      if (spacesStage == STAGE_INITIALIZING) attributes.add("spaces");
      if (stacksStage == STAGE_INITIALIZING) attributes.add("stacks");
      if (cloudFoundryClientPublisherStage == STAGE_INITIALIZING) attributes.add("cloudFoundryClientPublisher");
      if (dopplerClientPublisherStage == STAGE_INITIALIZING) attributes.add("dopplerClientPublisher");
      if (organizationIdStage == STAGE_INITIALIZING) attributes.add("organizationId");
      if (spaceIdStage == STAGE_INITIALIZING) attributes.add("spaceId");
      if (uaaClientPublisherStage == STAGE_INITIALIZING) attributes.add("uaaClientPublisher");
      if (usernameStage == STAGE_INITIALIZING) attributes.add("username");
      return "Cannot build DefaultCloudFoundryOperations, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The computed-at-construction value of the {@code advanced} attribute
   */
  @Override
  public Advanced advanced() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.advanced()
        : this.advanced;
  }

  /**
   * @return The computed-at-construction value of the {@code applications} attribute
   */
  @Override
  public Applications applications() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.applications()
        : this.applications;
  }

  /**
   * @return The computed-at-construction value of the {@code buildpacks} attribute
   */
  @Override
  public Buildpacks buildpacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.buildpacks()
        : this.buildpacks;
  }

  /**
   * @return The computed-at-construction value of the {@code domains} attribute
   */
  @Override
  public Domains domains() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.domains()
        : this.domains;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationAdmin} attribute
   */
  @Override
  public OrganizationAdmin organizationAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizationAdmin()
        : this.organizationAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code organizations} attribute
   */
  @Override
  public Organizations organizations() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.organizations()
        : this.organizations;
  }

  /**
   * @return The computed-at-construction value of the {@code routes} attribute
   */
  @Override
  public Routes routes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.routes()
        : this.routes;
  }

  /**
   * @return The computed-at-construction value of the {@code serviceAdmin} attribute
   */
  @Override
  public ServiceAdmin serviceAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.serviceAdmin()
        : this.serviceAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code services} attribute
   */
  @Override
  public Services services() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.services()
        : this.services;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceAdmin} attribute
   */
  @Override
  public SpaceAdmin spaceAdmin() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaceAdmin()
        : this.spaceAdmin;
  }

  /**
   * @return The computed-at-construction value of the {@code spaces} attribute
   */
  @Override
  public Spaces spaces() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.spaces()
        : this.spaces;
  }

  /**
   * @return The computed-at-construction value of the {@code stacks} attribute
   */
  @Override
  public Stacks stacks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.stacks()
        : this.stacks;
  }

  /**
   * The {@link CloudFoundryClient} to use for operations functionality
   */
  @Override
  public @Nullable CloudFoundryClient getCloudFoundryClient() {
    return cloudFoundryClient;
  }

  /**
   * @return The computed-at-construction value of the {@code cloudFoundryClientPublisher} attribute
   */
  @Override
  public Mono<CloudFoundryClient> getCloudFoundryClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCloudFoundryClientPublisher()
        : this.cloudFoundryClientPublisher;
  }

  /**
   * The {@link DopplerClient} to use for operations functionality
   */
  @Override
  public @Nullable DopplerClient getDopplerClient() {
    return dopplerClient;
  }

  /**
   * @return The computed-at-construction value of the {@code dopplerClientPublisher} attribute
   */
  @Override
  public Mono<DopplerClient> getDopplerClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDopplerClientPublisher()
        : this.dopplerClientPublisher;
  }

  /**
   * The organization to target
   */
  @Override
  public @Nullable String getOrganization() {
    return organization;
  }

  /**
   * @return The computed-at-construction value of the {@code organizationId} attribute
   */
  @Override
  public Mono<String> getOrganizationId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getOrganizationId()
        : this.organizationId;
  }

  /**
   * The space to target
   */
  @Override
  public @Nullable String getSpace() {
    return space;
  }

  /**
   * @return The computed-at-construction value of the {@code spaceId} attribute
   */
  @Override
  public Mono<String> getSpaceId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSpaceId()
        : this.spaceId;
  }

  /**
   * The {@link UaaClient} to use for operations functionality
   */
  @Override
  public @Nullable UaaClient getUaaClient() {
    return uaaClient;
  }

  /**
   * @return The computed-at-construction value of the {@code uaaClientPublisher} attribute
   */
  @Override
  public Mono<UaaClient> getUaaClientPublisher() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUaaClientPublisher()
        : this.uaaClientPublisher;
  }

  /**
   * @return The computed-at-construction value of the {@code username} attribute
   */
  @Override
  public Mono<String> getUsername() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsername()
        : this.username;
  }

  /**
   * This instance is equal to all instances of {@code DefaultCloudFoundryOperations} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DefaultCloudFoundryOperations
        && equalTo((DefaultCloudFoundryOperations) another);
  }

  private boolean equalTo(DefaultCloudFoundryOperations another) {
    return advanced.equals(another.advanced)
        && applications.equals(another.applications)
        && buildpacks.equals(another.buildpacks)
        && domains.equals(another.domains)
        && organizationAdmin.equals(another.organizationAdmin)
        && organizations.equals(another.organizations)
        && routes.equals(another.routes)
        && serviceAdmin.equals(another.serviceAdmin)
        && services.equals(another.services)
        && spaceAdmin.equals(another.spaceAdmin)
        && spaces.equals(another.spaces)
        && stacks.equals(another.stacks)
        && Objects.equals(cloudFoundryClient, another.cloudFoundryClient)
        && cloudFoundryClientPublisher.equals(another.cloudFoundryClientPublisher)
        && Objects.equals(dopplerClient, another.dopplerClient)
        && dopplerClientPublisher.equals(another.dopplerClientPublisher)
        && Objects.equals(organization, another.organization)
        && organizationId.equals(another.organizationId)
        && Objects.equals(space, another.space)
        && spaceId.equals(another.spaceId)
        && Objects.equals(uaaClient, another.uaaClient)
        && uaaClientPublisher.equals(another.uaaClientPublisher)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code advanced}, {@code applications}, {@code buildpacks}, {@code domains}, {@code organizationAdmin}, {@code organizations}, {@code routes}, {@code serviceAdmin}, {@code services}, {@code spaceAdmin}, {@code spaces}, {@code stacks}, {@code cloudFoundryClient}, {@code cloudFoundryClientPublisher}, {@code dopplerClient}, {@code dopplerClientPublisher}, {@code organization}, {@code organizationId}, {@code space}, {@code spaceId}, {@code uaaClient}, {@code uaaClientPublisher}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + advanced.hashCode();
    h = h * 17 + applications.hashCode();
    h = h * 17 + buildpacks.hashCode();
    h = h * 17 + domains.hashCode();
    h = h * 17 + organizationAdmin.hashCode();
    h = h * 17 + organizations.hashCode();
    h = h * 17 + routes.hashCode();
    h = h * 17 + serviceAdmin.hashCode();
    h = h * 17 + services.hashCode();
    h = h * 17 + spaceAdmin.hashCode();
    h = h * 17 + spaces.hashCode();
    h = h * 17 + stacks.hashCode();
    h = h * 17 + Objects.hashCode(cloudFoundryClient);
    h = h * 17 + cloudFoundryClientPublisher.hashCode();
    h = h * 17 + Objects.hashCode(dopplerClient);
    h = h * 17 + dopplerClientPublisher.hashCode();
    h = h * 17 + Objects.hashCode(organization);
    h = h * 17 + organizationId.hashCode();
    h = h * 17 + Objects.hashCode(space);
    h = h * 17 + spaceId.hashCode();
    h = h * 17 + Objects.hashCode(uaaClient);
    h = h * 17 + uaaClientPublisher.hashCode();
    h = h * 17 + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultCloudFoundryOperations} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultCloudFoundryOperations{"
        + "advanced=" + advanced
        + ", applications=" + applications
        + ", buildpacks=" + buildpacks
        + ", domains=" + domains
        + ", organizationAdmin=" + organizationAdmin
        + ", organizations=" + organizations
        + ", routes=" + routes
        + ", serviceAdmin=" + serviceAdmin
        + ", services=" + services
        + ", spaceAdmin=" + spaceAdmin
        + ", spaces=" + spaces
        + ", stacks=" + stacks
        + ", cloudFoundryClient=" + cloudFoundryClient
        + ", cloudFoundryClientPublisher=" + cloudFoundryClientPublisher
        + ", dopplerClient=" + dopplerClient
        + ", dopplerClientPublisher=" + dopplerClientPublisher
        + ", organization=" + organization
        + ", organizationId=" + organizationId
        + ", space=" + space
        + ", spaceId=" + spaceId
        + ", uaaClient=" + uaaClient
        + ", uaaClientPublisher=" + uaaClientPublisher
        + ", username=" + username
        + "}";
  }

  /**
   * Creates a builder for {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
   * @return A new DefaultCloudFoundryOperations builder
   */
  public static DefaultCloudFoundryOperations.Builder builder() {
    return new DefaultCloudFoundryOperations.Builder();
  }

  /**
   * Builds instances of type {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private CloudFoundryClient cloudFoundryClient;
    private DopplerClient dopplerClient;
    private String organization;
    private String space;
    private UaaClient uaaClient;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultCloudFoundryOperations} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultCloudFoundryOperations instance) {
      return from((_DefaultCloudFoundryOperations) instance);
    }

    /**
     * Copy abstract value type {@code _DefaultCloudFoundryOperations} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DefaultCloudFoundryOperations instance) {
      Objects.requireNonNull(instance, "instance");
      CloudFoundryClient cloudFoundryClientValue = instance.getCloudFoundryClient();
      if (cloudFoundryClientValue != null) {
        cloudFoundryClient(cloudFoundryClientValue);
      }
      DopplerClient dopplerClientValue = instance.getDopplerClient();
      if (dopplerClientValue != null) {
        dopplerClient(dopplerClientValue);
      }
      String organizationValue = instance.getOrganization();
      if (organizationValue != null) {
        organization(organizationValue);
      }
      String spaceValue = instance.getSpace();
      if (spaceValue != null) {
        space(spaceValue);
      }
      UaaClient uaaClientValue = instance.getUaaClient();
      if (uaaClientValue != null) {
        uaaClient(uaaClientValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getCloudFoundryClient() cloudFoundryClient} attribute.
     * @param cloudFoundryClient The value for cloudFoundryClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cloudFoundryClient(@Nullable CloudFoundryClient cloudFoundryClient) {
      this.cloudFoundryClient = cloudFoundryClient;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getDopplerClient() dopplerClient} attribute.
     * @param dopplerClient The value for dopplerClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dopplerClient(@Nullable DopplerClient dopplerClient) {
      this.dopplerClient = dopplerClient;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getOrganization() organization} attribute.
     * @param organization The value for organization (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organization(@Nullable String organization) {
      this.organization = organization;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getSpace() space} attribute.
     * @param space The value for space (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(@Nullable String space) {
      this.space = space;
      return this;
    }

    /**
     * Initializes the value for the {@link _DefaultCloudFoundryOperations#getUaaClient() uaaClient} attribute.
     * @param uaaClient The value for uaaClient (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uaaClient(@Nullable UaaClient uaaClient) {
      this.uaaClient = uaaClient;
      return this;
    }

    /**
     * Builds a new {@link DefaultCloudFoundryOperations DefaultCloudFoundryOperations}.
     * @return An immutable instance of DefaultCloudFoundryOperations
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DefaultCloudFoundryOperations build() {
      return new DefaultCloudFoundryOperations(this);
    }
  }
}
