package org.cloudfoundry.operations.buildpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _Buildpack}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Buildpack.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_Buildpack"})
public final class Buildpack extends org.cloudfoundry.operations.buildpacks._Buildpack {
  private final Boolean enabled;
  private final String filename;
  private final String id;
  private final Boolean locked;
  private final String name;
  private final Integer position;

  private Buildpack(Buildpack.Builder builder) {
    this.enabled = builder.enabled;
    this.filename = builder.filename;
    this.id = builder.id;
    this.locked = builder.locked;
    this.name = builder.name;
    this.position = builder.position;
  }

  /**
   * The enabled flag
   */
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * The filename
   */
  @Override
  public String getFilename() {
    return filename;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The locked flag
   */
  @Override
  public Boolean getLocked() {
    return locked;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The position
   */
  @Override
  public Integer getPosition() {
    return position;
  }

  /**
   * This instance is equal to all instances of {@code Buildpack} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Buildpack
        && equalTo((Buildpack) another);
  }

  private boolean equalTo(Buildpack another) {
    return enabled.equals(another.enabled)
        && filename.equals(another.filename)
        && id.equals(another.id)
        && locked.equals(another.locked)
        && name.equals(another.name)
        && position.equals(another.position);
  }

  /**
   * Computes a hash code from attributes: {@code enabled}, {@code filename}, {@code id}, {@code locked}, {@code name}, {@code position}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + enabled.hashCode();
    h = h * 17 + filename.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + locked.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + position.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Buildpack} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Buildpack{"
        + "enabled=" + enabled
        + ", filename=" + filename
        + ", id=" + id
        + ", locked=" + locked
        + ", name=" + name
        + ", position=" + position
        + "}";
  }

  /**
   * Creates a builder for {@link Buildpack Buildpack}.
   * @return A new Buildpack builder
   */
  public static Buildpack.Builder builder() {
    return new Buildpack.Builder();
  }

  /**
   * Builds instances of type {@link Buildpack Buildpack}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ENABLED = 0x1L;
    private static final long INIT_BIT_FILENAME = 0x2L;
    private static final long INIT_BIT_ID = 0x4L;
    private static final long INIT_BIT_LOCKED = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_POSITION = 0x20L;
    private long initBits = 0x3fL;

    private Boolean enabled;
    private String filename;
    private String id;
    private Boolean locked;
    private String name;
    private Integer position;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Buildpack} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Buildpack instance) {
      return from((_Buildpack) instance);
    }

    /**
     * Copy abstract value type {@code _Buildpack} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Buildpack instance) {
      Objects.requireNonNull(instance, "instance");
      enabled(instance.getEnabled());
      filename(instance.getFilename());
      id(instance.getId());
      locked(instance.getLocked());
      name(instance.getName());
      position(instance.getPosition());
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getFilename() filename} attribute.
     * @param filename The value for filename 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filename(String filename) {
      this.filename = Objects.requireNonNull(filename, "filename");
      initBits &= ~INIT_BIT_FILENAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getLocked() locked} attribute.
     * @param locked The value for locked 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder locked(Boolean locked) {
      this.locked = Objects.requireNonNull(locked, "locked");
      initBits &= ~INIT_BIT_LOCKED;
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _Buildpack#getPosition() position} attribute.
     * @param position The value for position 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder position(Integer position) {
      this.position = Objects.requireNonNull(position, "position");
      initBits &= ~INIT_BIT_POSITION;
      return this;
    }

    /**
     * Builds a new {@link Buildpack Buildpack}.
     * @return An immutable instance of Buildpack
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Buildpack build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Buildpack(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      if ((initBits & INIT_BIT_FILENAME) != 0) attributes.add("filename");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_LOCKED) != 0) attributes.add("locked");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_POSITION) != 0) attributes.add("position");
      return "Cannot build Buildpack, some of required attributes are not set " + attributes;
    }
  }
}
