package org.cloudfoundry.operations.organizationadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _DeleteQuotaRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DeleteQuotaRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_DeleteQuotaRequest"})
public final class DeleteQuotaRequest
    extends org.cloudfoundry.operations.organizationadmin._DeleteQuotaRequest {
  private final String name;

  private DeleteQuotaRequest(DeleteQuotaRequest.Builder builder) {
    this.name = builder.name;
  }

  /**
   * The name of the quota
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code DeleteQuotaRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteQuotaRequest
        && equalTo((DeleteQuotaRequest) another);
  }

  private boolean equalTo(DeleteQuotaRequest another) {
    return name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteQuotaRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteQuotaRequest{"
        + "name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteQuotaRequest DeleteQuotaRequest}.
   * @return A new DeleteQuotaRequest builder
   */
  public static DeleteQuotaRequest.Builder builder() {
    return new DeleteQuotaRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteQuotaRequest DeleteQuotaRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteQuotaRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteQuotaRequest instance) {
      return from((_DeleteQuotaRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteQuotaRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteQuotaRequest instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteQuotaRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link DeleteQuotaRequest DeleteQuotaRequest}.
     * @return An immutable instance of DeleteQuotaRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteQuotaRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteQuotaRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build DeleteQuotaRequest, some of required attributes are not set " + attributes;
    }
  }
}
