package org.cloudfoundry.operations.organizationadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _SetQuotaRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SetQuotaRequest.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SetQuotaRequest"})
public final class SetQuotaRequest extends org.cloudfoundry.operations.organizationadmin._SetQuotaRequest {
  private final String organizationName;
  private final String quotaName;

  private SetQuotaRequest(SetQuotaRequest.Builder builder) {
    this.organizationName = builder.organizationName;
    this.quotaName = builder.quotaName;
  }

  /**
   * The name of the organization on which the quota must be set
   */
  @Override
  public String getOrganizationName() {
    return organizationName;
  }

  /**
   * The name of the quota that will be set
   */
  @Override
  public String getQuotaName() {
    return quotaName;
  }

  /**
   * This instance is equal to all instances of {@code SetQuotaRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SetQuotaRequest
        && equalTo((SetQuotaRequest) another);
  }

  private boolean equalTo(SetQuotaRequest another) {
    return organizationName.equals(another.organizationName)
        && quotaName.equals(another.quotaName);
  }

  /**
   * Computes a hash code from attributes: {@code organizationName}, {@code quotaName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + organizationName.hashCode();
    h = h * 17 + quotaName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SetQuotaRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SetQuotaRequest{"
        + "organizationName=" + organizationName
        + ", quotaName=" + quotaName
        + "}";
  }

  /**
   * Creates a builder for {@link SetQuotaRequest SetQuotaRequest}.
   * @return A new SetQuotaRequest builder
   */
  public static SetQuotaRequest.Builder builder() {
    return new SetQuotaRequest.Builder();
  }

  /**
   * Builds instances of type {@link SetQuotaRequest SetQuotaRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ORGANIZATION_NAME = 0x1L;
    private static final long INIT_BIT_QUOTA_NAME = 0x2L;
    private long initBits = 0x3L;

    private String organizationName;
    private String quotaName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SetQuotaRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SetQuotaRequest instance) {
      return from((_SetQuotaRequest) instance);
    }

    /**
     * Copy abstract value type {@code _SetQuotaRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SetQuotaRequest instance) {
      Objects.requireNonNull(instance, "instance");
      organizationName(instance.getOrganizationName());
      quotaName(instance.getQuotaName());
      return this;
    }

    /**
     * Initializes the value for the {@link _SetQuotaRequest#getOrganizationName() organizationName} attribute.
     * @param organizationName The value for organizationName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationName(String organizationName) {
      this.organizationName = Objects.requireNonNull(organizationName, "organizationName");
      initBits &= ~INIT_BIT_ORGANIZATION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _SetQuotaRequest#getQuotaName() quotaName} attribute.
     * @param quotaName The value for quotaName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder quotaName(String quotaName) {
      this.quotaName = Objects.requireNonNull(quotaName, "quotaName");
      initBits &= ~INIT_BIT_QUOTA_NAME;
      return this;
    }

    /**
     * Builds a new {@link SetQuotaRequest SetQuotaRequest}.
     * @return An immutable instance of SetQuotaRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SetQuotaRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SetQuotaRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ORGANIZATION_NAME) != 0) attributes.add("organizationName");
      if ((initBits & INIT_BIT_QUOTA_NAME) != 0) attributes.add("quotaName");
      return "Cannot build SetQuotaRequest, some of required attributes are not set " + attributes;
    }
  }
}
