package org.cloudfoundry.operations.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link _SecurityGroup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SecurityGroup.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "_SecurityGroup"})
public final class SecurityGroup extends org.cloudfoundry.operations.spaces._SecurityGroup {
  private final String name;
  private final List<Rule> rules;

  private SecurityGroup(SecurityGroup.Builder builder) {
    this.name = builder.name;
    this.rules = createUnmodifiableList(true, builder.rules);
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The rules
   */
  @Override
  public List<Rule> getRules() {
    return rules;
  }

  /**
   * This instance is equal to all instances of {@code SecurityGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SecurityGroup
        && equalTo((SecurityGroup) another);
  }

  private boolean equalTo(SecurityGroup another) {
    return name.equals(another.name)
        && rules.equals(another.rules);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code rules}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + rules.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SecurityGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SecurityGroup{"
        + "name=" + name
        + ", rules=" + rules
        + "}";
  }

  /**
   * Creates a builder for {@link SecurityGroup SecurityGroup}.
   * @return A new SecurityGroup builder
   */
  public static SecurityGroup.Builder builder() {
    return new SecurityGroup.Builder();
  }

  /**
   * Builds instances of type {@link SecurityGroup SecurityGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String name;
    private List<Rule> rules = new ArrayList<Rule>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SecurityGroup} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SecurityGroup instance) {
      return from((_SecurityGroup) instance);
    }

    /**
     * Copy abstract value type {@code _SecurityGroup} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SecurityGroup instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      addAllRules(instance.getRules());
      return this;
    }

    /**
     * Initializes the value for the {@link _SecurityGroup#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link _SecurityGroup#getRules() rules} list.
     * @param element A rules element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(Rule element) {
      this.rules.add(Objects.requireNonNull(element, "rules element"));
      return this;
    }

    /**
     * Adds elements to {@link _SecurityGroup#getRules() rules} list.
     * @param elements An array of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rule(Rule... elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _SecurityGroup#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rules(Iterable<? extends Rule> elements) {
      this.rules.clear();
      return addAllRules(elements);
    }

    /**
     * Adds elements to {@link _SecurityGroup#getRules() rules} list.
     * @param elements An iterable of rules elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRules(Iterable<? extends Rule> elements) {
      for (Rule element : elements) {
        this.rules.add(Objects.requireNonNull(element, "rules element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SecurityGroup SecurityGroup}.
     * @return An immutable instance of SecurityGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SecurityGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new SecurityGroup(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build SecurityGroup, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
